
#declare building_length = 20.0;
#declare building_width = 15.0;
#declare building_height = 4.0;

#declare wall_texture =
  texture{pigment{bozo scale <0.15,0.15,2>
                  color_map{[0.0 color rgb<0.8,0.8,0.7>]
                            [0.45 color rgb<0.8,0.8,0.7>]
                            [0.55 color rgb<1.0,1.0,0.8>]
                            [1.0 color rgb<1.0,1.0,0.8>]}
                 }
       finish{ambient rgb 0.5}
      }

#declare roof_texture =
   texture{pigment{bozo scale <0.3,0.3,2>
                   colour_map{[0 color rgb<0.3,0.3,0.1>]
                              [1 color rgb<0.7,0.7,0.6>]}}
           finish{ambient rgb 0.5}
          }

#declare window_texture =
   texture{pigment{gradient -z  triangle_wave  
                   color_map{[0 color rgb 0.5]
                             [1 color rgb 1]}
                  } scale 0.35 translate <0,0,0.6>
           finish{ambient rgb 1}
          }

// Building
union{

  // End wall
  polygon{26,<-10,7.5,0><-10,7.5,2.4><-10,0,4><-10,-7.5,2.4><-10,-7.5,0><-10,7.5,0>
             <-10,6.5,0.8><-10,6.5,2><-10,4,2><-10,4,0.8><-10,6.5,0.8>
             <-10,3,0.8><-10,3,2><-10,0.5,2><-10,0.5,0.8><-10,3,0.8>
             <-10,-0.5,0.8><-10,-0.5,2><-10,-3,2><-10,-3,0.8><-10,-0.5,0.8>
             <-10,-4,0.8><-10,-4,2><-10,-6.5,2><-10,-6.5,0.8><-10,-4,0.8>
             texture{wall_texture}}

 // Front wall
 polygon{30,<-10,-7.5,0><-10,-7.5,2.4><10,-7.5,2.4><10,-7.5,0><-10,-7.5,0>
            // door hole
            <-9.0,-7.5,0><-9.0,-7.5,2><-8.0,-7.5,2><-8.0,-7.5,0><-9.0,-7.5,0>
            // windows
            <-7.0,-7.5,0.8><-7.0,-7.5,2><-4,-7.5,2><-4,-7.5,0.8><-7,-7.5,0.8>
            <-3.0,-7.5,0.8><-3.0,-7.5,2><0.0,-7.5,2><0.0,-7.5,0.8><-3.0,-7.5,0.8>
            <1,-7.5,0.8><1,-7.5,2><4,-7.5,2><4,-7.5,0.8><1,-7.5,0.8>
            <5,-7.5,0.8><5,-7.5,2><8,-7.5,2><8,-7.5,0.8><5,-7.5,0.8>
            texture{wall_texture}}

  // Windows
  box{<-9.9,-7.4,0><9.9,7.4,2.1> texture{window_texture}}

  // Door
  polygon{5, <-9.0,-7.45,0><-9.0,-7.45,2><-8.0,-7.45,2><-8.0,-7.45,0><-9.0,-7.45,0>          
          pigment{color rgb <0.6,0.6,0.5>}
          finish{ambient rgb 0.5}
         }

  // Roof
  polygon{5,
          <-0.5*building_length-0.5, -0.5*building_width-0.5, 2.2933333>
          <-0.5*building_length-0.5, 0, building_height>
          < 0.5*building_length+0.5, 0, building_height>
          < 0.5*building_length+0.5, -0.5*building_width-0.5, 2.2933333>
          <-0.5*building_length-0.5, -0.5*building_width-0.5, 2.2933333>
          texture{roof_texture}
          }
  polygon{5,
          <-0.5*building_length-0.5, 0.5*building_width+0.5, 2.2933333>
          <-0.5*building_length-0.5, 0, building_height>
          < 0.5*building_length+0.5, 0, building_height>
          < 0.5*building_length+0.5, 0.5*building_width+0.5, 2.2933333>
          <-0.5*building_length-0.5, 0.5*building_width+0.5, 2.2933333>
          texture{roof_texture}
          }
}

