
#include "functions.inc"
#include "scene.inc"
#include "objects.inc"

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       #if ( clock < 0.5 )
         rotate<12,0,0>
         translate<0,-50,1.5>
       #end
       #if ( clock >= 0.5 & clock <= 1.0 )
         #declare tc = (clock-0.5)/0.5;
         rotate<12-12*motion(tc),0,0>
         translate<0, -50 - 60*motion(tc),1.5-1.5*motion(tc)>
         rotate<-90*motion(tc),0,0>
       #end
      }

light_source{<1e6,-1e6,1e5> color rgb 0.9}
light_source{<-1e6,-1e6,1e7> color rgb 0.4 shadowless}
global_settings{ambient_light rgb 0.5}

fog{distance 300 color rgbf<1,1,1,0.5>}
object{ground}    
#if ( clock < 0.75 )
  object{low_cloud}
#end

// Logo debris
#declare p = pigment{image_map{png "flagmap1.png"}};
#declare R2 = seed(2);
#declare ni = 100;
#declare nj = 100;
#declare i = 0;
#while(i < ni)
  #declare ti = i/(ni-1);
  #declare j = 0;
  #while(j < nj)
    #declare tj = j/(nj-1);
    #declare vr = <20+rand(R2)*20,rand(R2)*20,rand(R2)*360>;
    #declare s = 0.3+0.8*rand(R2);
    #declare c = eval_pigment(p, <ti,tj,0>);
    #declare px = 80*ti-40 + 2*(rand(R2)-0.5);
    #declare py = 60*tj-30 + 2*(rand(R2)-0.5);
    #if (c.x < 0.9 )
        make_splinter(<px,py,0.4>, s, vr)
    #end
    #declare j = j + 1;
  #end
  #declare i = i + 1;
#end

// Debris
#declare R3 = seed(3);
#declare ni = 2000;
#declare i = 0;
#while(i < ni)
  #declare vr = <rand(R3)*40,rand(R3)*10,rand(R3)*360>;
  #declare s = 0.3+0.8*rand(R3);
  #declare theta = rand(R3)*2*pi;
  #declare sr = rand(R3) * 100;
  make_splinter(<sr*cos(theta),sr*sin(theta),0.4>, s, vr)

  #declare i = i + 1;
#end

// Objects
#declare R1 = seed(4);
#declare ni = 40;
#declare i = 0;
#while(i < ni)
  #declare t_debris = i/(ni-1);
  #declare start_time = -0.1 + t_debris * 0.35;
  #declare stop_time = start_time + 0.15;
  #if ((clock >= start_time) & (clock <= stop_time))
     #declare t_path = (clock - start_time) / (stop_time - start_time);
  #else
     #declare t_path = 2;
  #end

  #declare theta = rand(R1)*2*pi;
  #declare or = 2;
  #declare ox = or * cos(theta);
  #declare oy = or * sin(theta);
  #declare oz = 30 - t_path * 80;

  #declare ax = rand(R1)*360 + clock*1000;
  #declare ay = rand(R1)*360 + clock*1300;
  #declare az = rand(R1)*360 + clock*1500;

  #declare theta_s = rand(R1)*360;
  #declare vr = <rand(R1)*360,rand(R1)*360,rand(R1)*360>;
  #declare s = 0.2+0.8*rand(R1);

  #if (t_path <= 1.0)

    #declare o = mod(i,4);
    make_object( o, ox, oy, oz, ax, ay, az )
  
    #if ( oz < 0 )
      #declare ts = -oz / 50;
      #declare ps = <ox, oy, 6*sin(ts*pi)>;
      make_splinter(ps, s, vr )
    #end

  #end

  #declare i=i+1;

#end


// Heap
#declare R4 = seed(5);
#declare ni = 100;
#declare i = 0;
#while(i < ni)
  #declare t_debris = i/(ni-1);
  #declare theta = rand(R4)*360;
  #declare tr = 1-pow(t_debris,2);
  #declare rh = tr*3;
  #declare p = <rh*cos(theta), rh*sin(theta), t_debris*1.5>;
  #declare vr = <rand(R4)*360,rand(R4)*360,rand(R4)*360>;
  #if( clock > (0.4*t_debris))
    make_splinter(p, 1, vr )
  #end
  #declare i=i+1;
#end

