
#include "twister.inc"
#include "objects.inc"
#include "scene.inc"

global_settings{max_trace_level 5}

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<90,0,0>
      }

light_source{<1e+06,-1e+06,1e+06>color rgb 0.9}
light_source{<-1e6,-1e+06,-1e06> color rgb 0.7 shadowless}
global_settings{ambient_light rgb 0.8}

object{light_cloud translate<0,0,100>}

// Twister
#if (clock <= 0.9)
  #declare tx = 2*cos(-clock*3*pi);
  #declare ty = 2*sin(-clock*3*pi);
  #declare twister_rotation = clock*twister_speed*(0.5-0.2*clock);
  #declare twister_density = 0.5 - 0.5 * clock/0.9;
  make_twister( tx, ty, 60, 40, 4, 20, twister_rotation, twister_density)
#end

// Objects
#declare R1 = seed(4);
#declare ni = 40;
#declare i=0;
#while (i<ni)
  #declare ti = i / (ni-1);
  #declare theta_phase = rand(R1)*2*pi;
  #declare tr = rand(R1);
  #declare or = 1 + tr * 2;
  #declare theta = clock*(1 + (1-tr))*pi;

  #declare ox = or * cos(theta+theta_phase);
  #declare oy = or * sin(theta+theta_phase);
  #declare oz = 100 + ti*70 - clock * 100;

  #declare ax = rand(R1)*360 + clock*1000;
  #declare ay = rand(R1)*360 + clock*1300;
  #declare az = rand(R1)*360 + clock*1500;

  #declare o = mod(i,4);
  make_object( o, ox, oy, oz, ax, ay, az )

  #declare i=i+1;
#end

