
global_settings{ambient_light rgb 1}
camera{orthographic 
       location<0,0,1000> right<320,0,0> up<0,240,0> direction<0,0,-1>}
plane{z, -1000 pigment{rgb<1,1,1>} finish{ambient 1}}

#declare logo_colour = texture{pigment{rgb<0.7,0.8,0.9>}finish{ambient 1}};

sphere{<0,0,0>,1 texture{logo_colour} scale<30,30,1> }
#declare swirl = 
  sphere_sweep{cubic_spline 5,
    <0.3,-1,0>,   0.3
    <0, 0,0>,     0.25
    <0.3, 0.7,0>, 0.2
    <1, 1, 0>,    0.1
    <2, 0.7,0>,   0.05
    tolerance 1e-1
    texture{logo_colour} 
    rotate<0,0,-30>
    scale 50
   }

#declare ni=7;
#declare i=0;
#while (i<ni)
  #declare theta = 360 * i/ni;
  object{swirl translate<0,50,0>rotate<0,0,theta>}
  #declare i=i+1;
#end

// Only put text on second image
#if ( clock > 0.5 )

 #declare text_colour = texture{pigment{rgb<0,0,0>}finish{ambient 1}};
 #declare text_x = -120;
 #declare text_scale = 60;

 text{ttf "cyrvetic.ttf" "Tornado"  1, 0 texture{text_colour}
    scale text_scale translate<text_x+15,55,100>}
 text{ttf "cyrvetic.ttf" "Research" 1, 0 texture{text_colour}
    scale text_scale translate<text_x,-15,100>}
 text{ttf "cyrvetic.ttf" "Institute"  1, 0 texture{text_colour}
    scale text_scale translate<text_x+25,-85,100>}

#end

