
#include "scene.inc"
#include "building.inc"
#include "twister.inc"

global_settings{max_trace_level 5}

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<12,0,-24>translate<-25,-90,2.0>
      }

light_source{<1e+06,-1e+05,1e+05>colour rgb 0.9}
light_source{<1e5,-1e+07,1e06> colour rgb 0.7 shadowless}
global_settings{ambient_light colour rgb 0.5}

fog{distance 300 colour rgbf<1,1,1,0.5>}
object{ground}
object{low_cloud}

// Flag
#declare fx = 4 - clock * 200;
#if ( fx > -30 )
  mesh{
       triangle{<1.5,0,-1><1.5,0,1><-1.5,0,1> uv_vectors <1,0>,<1,1>,<0,1>}
       triangle{<-1.5,0,1><-1.5,0,-1><1.5,0,-1> uv_vectors <0,1>,<0,0>,<1,0>}
       texture{pigment{uv_mapping image_map{png "flagmap2.png"} }
               finish{ambient rgb 0.5}
               normal{bumps 1 scale 1 translate<-20*clock,0,0>} }
       rotate<clock*1000,clock*1100,clock*1300>
       translate<fx,0,8>
      }
#end

// Pole
#declare fx = 0.2*(sin(140*clock) + sin(150*clock));
sphere_sweep{cubic_spline 7,
    <0,0,-2>, 0.3
    <0,0,0>, 0.3
    <0,0,2>, 0.25
    <0.25*fx, 0,4>, 0.2
    <0.5*fx, 0,6>, 0.15
    <fx, 0,8>, 0.15
    <1.5*fx, 0,10>, 0.15
    translate<20,0,0>
  texture{pigment{color rgb 1}finish{ambient rgb 0.5}}
  }
sphere{<fx+20,0,8>, 0.15 texture{pigment{color rgb 1}finish{ambient rgb 0.5}}}

// Twister
#declare tx = 60 - 35 * clock;
#declare tr = 0.01 + 7 * clock;
#declare twister_depth = 1 + 55*clock;
#declare twister_rotation = pow(clock,3) * 0.25 * twister_speed;
#declare twister_density = 0.8 * pow(clock,0.2);
make_twister( tx, 0, 61, 60, tr, twister_depth, twister_rotation, twister_density )

