
#include "scene.inc"
#include "building.inc"

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<10,0,-23>translate<-20,-60,1.5>
      }

light_source{<1e6,-1e6,1e4>color rgb 0.9}
light_source{<-1e4,-1e6,1e6> color rgb 0.7 shadowless}
global_settings{ambient_light rgb 0.5}

fog{distance 300 color rgbf<1,1,1,0.5>}
object{ground}
object{low_cloud}

// Flag
#declare fx = 20;
#declare fy = 0;
sphere_sweep{cubic_spline 7,
    <fx,fy, -2>, 0.3
    <fx,fy, 0>, 0.3
    <fx,fy, 2>, 0.25
    <fx,fy, 4>, 0.2
    <fx,fy, 6>, 0.15
    <fx,fy, 8>, 0.15
    <fx,fy, 10>, 0.15
  texture{pigment{color rgb 1}finish{ambient rgb 0.5}}
  }
sphere{<fx,fy,8>, 0.15 texture{pigment{color rgb 1}finish{ambient rgb 0.5}}}

#declare fz0 = 0.25*sin(clock*pi*13)+0.25*cos(clock*pi*15);
#declare fz1 = 0.25*sin(clock*pi*17)+0.25*cos(clock*pi*19);
mesh{
    triangle{<fx,fy,6> <fx,fy,8> <fx-3,fy,7+fz1>
              uv_vectors <1,0>,<1,1>,<0,1>}
    triangle{<fx-3,fy,7+fz1> <fx-3,fy,5.5+fz0>  <fx,fy,6> 
              uv_vectors <0,1>,<0,0>,<1,0>}
    texture{pigment{uv_mapping image_map{png "flagmap2.png"} }
            finish{ambient rgb 0.5}
            normal{bumps 1 scale 1 translate<-10*clock,0,0>}
           }
    }

