
#include "scene.inc"
#include "twister.inc"

global_settings { max_trace_level 5 }

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<90,0,0>translate<0,0,-3>
      }
light_source{<1e6, -1e6, 1e6>color rgb 0.9 shadowless}
light_source{<-1e6, -1e6, -1e6> color rgb 0.7 shadowless}
global_settings{ambient_light rgb 1}

object{light_cloud translate<0,0,100>}

// Pole
#declare fx = (0.1 + 0.5 * clock) * cos(clock*20*pi);
#declare fy = (0.1 + 0.5 * clock) * sin(clock*29*pi);
union{
sphere_sweep{cubic_spline 6,
    <0,0, -5>, 0.25
    <0,0, -3>, 0.25
    <0.1*fx,0.1*fy, -1>, 0.2
    <0.4*fx,0.4*fy, 1>, 0.15
    <fx,fy, 3>, 0.1
    <fx,fy, 5>, 0.1
    texture{pigment{color rgb 1}finish{ambient rgb 0.5}}
    translate<-1,0.0>}
sphere{<fx-1,fy,3>, 0.15 texture{pigment{color rgb 1}finish{ambient rgb 0.8}}}

 #if (clock > 0.3)
     #declare t_up = (clock-0.3) / 0.7;
     rotate<t_up*t_up*500, t_up*t_up*520, t_up*t_up*540>
     translate<6*t_up*cos(t_up*4*pi),
               6*t_up*sin(t_up*4*pi),
               70*t_up>
 #end

}

// Twister
#declare tx = 2*cos(-clock*2*pi);
#declare ty = 2*sin(-clock*2*pi);
#declare twister_rotation = clock * twister_speed;
make_twister( tx, ty, 80, 10, 8,  85, twister_rotation,  0.9 )

