
background{color rgb 1}

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
#declare camera_location  = <0,0,0>;
#declare camera_direction = <0,focal_length,0>;
#declare camera_right = <film_size,0,0>;
#declare camera_up = <0,0,film_size*aspect_ratio>;

#macro make_splinter( p, s, vr )
   polygon{5, <-1,-0.4,0><-1,0.4,0><1,0.2,0><1,-0.2,0><-1,-0.4,0>
           scale s
           rotate vr
           translate p
           pigment{colour rgb<0.9,0.9,0.7>}
           finish{diffuse 1 phong 1 ambient 0.7}
          }
#end

#declare motion=function(m){0.5*(1+cos(pi*(m+1)))}

#declare low_cloud =
     plane{z, 60 texture{
              pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                      colour_map{[0.0 colour rgb 0][1.0 colour rgb 1]}
                      }
                     finish{ambient 1.0}
                     scale <50,40,1>
                    }
         hollow no_shadow};

#declare light_cloud =
     plane{z, 60 texture{
        pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                colour_map{[0.0 colour rgb 0.6][1.0 colour rgb 0.9]}
               }
               finish{ambient 1.0}
               scale 20
                        }
         hollow no_shadow}

#declare ground = 
     plane{z, 0 texture{
                pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                             colour_map{[0.0 colour rgb <0.3,0.3,0.2>]
                                        [0.4 colour rgb <0.4,0.4,0.3>]
                                        [0.45 colour rgb <0.6,0.6,0.5>]
                                        [1 colour rgb <0.9,0.9,0.7>]
                                       }
                               }
                        finish{ambient rgb 0.6} 
                        scale 0.4
                        }
          }

