
// POV-Ray Object File - Red Bobsled
// created 2-Nov-02
// last update 4-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Bobsled.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// RedsledS -- simple version
//
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Bobsled nose at X=0, rails at z=0, sled extends into +X
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare GlossyRed =
	texture {
		pigment { color rgb<.92,.001,.008>*1.00 }
		finish { specular 0.96 roughness .008 reflection 0 }
//		finish { specular 0.96 roughness .008 reflection <0.42,0.37,0.20> }
	}
#declare PaintStripePig =
	pigment {
		color rgb<.45,.40,.11>
	}

#declare GlossyFinish =
//	finish { specular 0.96 roughness .008 reflection <0.06,0.08,0.12> } // too reflective
	finish { specular 0.96 roughness .008 reflection <0.02,0.015,0.04> } // electric blue
//	finish { specular 0.96 roughness .008 reflection <0.04,0.025,0.01> } // yellowish
//	finish { specular 0.96 roughness .008  }

#declare SteelTex =
	texture {
		pigment { color rgb<.44,.41,.48>*.84 }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.60
			roughness .072
			reflection 0.45
		}
	}

#declare HelmetTex =
	texture {
		pigment { color rgb<.92,.001,.008>*1.00 }
//		finish { specular 0.96 roughness .008 reflection 0 }
		finish { specular 0.96 roughness .008 reflection <0.02,0.04,0.05> }
	}

#declare FaceShieldTex =
	texture {
		pigment { color rgbt<.182,.181,.182,.7> }
		finish { specular 0.96 roughness .008 reflection <0.02,0.04,0.05> }
	}

#declare SuitTex =
	texture {
		pigment { color rgb<.92,.01,.08>*1.00 }
		finish { specular 0.45 roughness .022 }
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

//------------ Athlete -------------------

#declare HelmetShape =
	difference {
		union {
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		sphere { // inside
			<0,0,0>,4.3
		}
		cylinder { // inside
			<0,0,0.1>,<0,0,-6,>4.3
		}
		box { // cut off back base
			<-8,-8,-6>,<8,8,0>
			rotate x*20
			translate <0,0,-3.2>
		}
/*
		cylinder { // faceplate cutout
			<0,-6,0>,<0,0,0>,3
			scale <1,1,.6>
			translate <0,0,-1>
		}
*/
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,0,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
	texture { HelmetTex }		
	} // end difference

#declare FaceShield =
	intersection {
		union { // outer
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		union { // inner
			sphere {
				<0,0,0>,4.8
			}
			cylinder {
				<0,0,0>,<0,0,-5>,4.8
			}
			inverse
		} // end union
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,6,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
		texture { FaceShieldTex }
	} // end intersection

#declare FaceS =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "Face.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <8,1,12>
				translate <-4,0,-6>
			}
			finish { ambient .6 }
		}
	}
#declare BackHead =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
	}
#declare Helmet =
	union {
		object { HelmetShape }
		object { FaceS }
		object { BackHead translate <0,0.1,0> }
		object { FaceShield translate <0,1,-1> rotate x*-60 translate <0,-1,1> }
	} // end union

#declare BobGuy =
	union {
//	RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(24,7,12,2.4)
			translate <-12,-3.2,-18>
			texture { SuitTex }
		}
		cylinder { // lower neck
			<0,0,-12>,<0,0,-4.5>,3.2
			scale <1,.6,1>
			texture { pigment { color rgb<1,1,1> } }
		}
		cylinder { // upper neck
			<0,0,-6>,<0,0,0>,2.8
			scale <1,.6,1>
			rotate x*-18
			translate <0,2,-2>
			texture { pigment { color rgb<1,1,1> } }
		}
	} // end union

#declare HelmetGroup =
	union {
		object { Helmet }
		object { BobGuy }
	} // end union

//------------ Simple version -------------------

#declare Runner =
	union {
		intersection {
			sphere {
				<0,0,0>,12
				scale <1,.2,.2>
			}
			box {
				<-15,-4,0>,<15,4,4>
			}
			translate <0,0,1.2>
		}
		box { // runner
			<-10,-0.2,0>,<10,0.2,2>
			texture { SteelTex }
		}
		texture { GlossyRed }
	} // end union
#declare RunnerGroupS =
	union {
		object { Runner translate <0,-12,0> }
		object { Runner translate <0,12,0> }
		cylinder { // cross support
			<0,-12,0>,<0,12,0>,2
			scale <1.3,1,.7>
			translate <0,0,4.3>
		}
		cylinder { // steering
			<0,0,0>,<0,0,8>,2
			scale <1.3,1,1>
			translate <0,0,4.3>
		}
		texture { GlossyRed }
	} // end union


#declare BobBaseS =
	union {
		sphere { // main
			<0,0,0>,12
			scale <4,1,1>
			translate <48,0,16>
		}
		cylinder {
			<0,0,0>,<5*Feet,0,0>,12
			translate <48,0,16>
		}
//     RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(5*Feet,24,16,4)
			rotate x*180
			translate <48,12,20>
		}
//		texture { GlossyRed }
	} // end union
#declare BobCutterS = // this cuts out the insides
	union {
		cylinder {
			<0,0,0>,<6*Feet,0,0>,11
			translate <48,0,22>
		}
		box { // back end
			<0,-30,-30>,<30,30,30>
			rotate y*-30
			translate <9*Feet,0,12>
		}
		texture { GlossyRed }
	} // end union
#declare RedsledS =
	union {
		difference {
			object { BobBaseS }
			object { BobCutterS }
		} // end difference
		object { RunnerGroupS translate <1*Feet,0,0> }
		object { RunnerGroupS translate <8*Feet,0,0> }
		texture { GlossyRed finish { GlossyFinish } }
	} // end union


//------------ Complex Version ------------------


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 30
		location  <-3*Feet, -30*Feet, 5*Feet> // overall
		look_at <0*Feet,0*Feet,2*Feet>
	}

//background { rgb<.43,.34,.95> } // sky blue
background { rgb<.03,.04,.05> } // black
light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.6
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
light_source
{ <-14*Feet,-12*Feet,130*Feet>, <1.00,1.18,1.03>*.4
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

object { RedsledS scale 1 rotate z*0 translate <-6*Feet,-10*Feet ,0*Feet> }
object { RedsledS scale 1 rotate z*70 translate <-6*Feet,7*Feet ,0*Feet> }
object { RedsledS scale 1 rotate z*-70 translate <4*Feet,12*Feet ,1.5*Feet> }

#end
