
// POV-Ray Object File - Scoreboard
// created 3-Jan-03
// last update 6-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Scoreboard.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Scoreboard
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Sky is +Z


//===============================================
//             Textures
//===============================================

#declare WhiteSignTex =
	texture {
		pigment { color rgb<.96,.98,.99>*1.3 }
		finish { ambient 0.14 specular 0.85 roughness 0.02 metallic }
	}
#declare BlackSignTex =
	texture {
		pigment { color rgb<.036,.038,.039> }
		finish { ambient 0.04 diffuse 0.4 specular 0.1 roughness 0.04 }
	}
#declare LEDTex =
	texture {
		pigment { color rgb<1.96,.98,.09> }
		finish { ambient 0.44 specular 0.5 roughness 0.04 }
	}




#declare StrArray = array[6]
#declare StrArray[0] = "1  Germany II"
#declare StrArray[1] = "2  Canada I"
#declare StrArray[2] = "3  Bulgaria"
#declare StrArray[3] = "4  Austria I"
#declare StrArray[4] = "5  Romania"
#declare StrArray[5] = "6  Austria II"
//#declare SignText =
#declare TimeArray = array[6]
//#declare TimeArray[0] = "  :59.007"
#declare TimeArray[0] = "1:06.463"
#declare TimeArray[1] = "1:06.509"
#declare TimeArray[2] = "1:07.122"
#declare TimeArray[3] = "1:07.126"
#declare TimeArray[4] = "1:07.139"
#declare TimeArray[5] = "1:07.221"

#declare SignText =
	union {
		#declare TCount = 0;
		#while ( TCount < 6 )
		text {
			ttf "arialbd.ttf"
			StrArray[TCount]
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <6,-0.0,25-TCount*4>
		}
		text {
			ttf "arialbd.ttf"
			TimeArray[TCount]
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <34,-0.0,25-TCount*4>
		}
		#declare TCount = TCount + 1;
		#end
		text {
			ttf "arialbd.ttf"
			"  STANDINGS"
			.1,0
			rotate x*90
			scale <3.4,1,3.4>
			translate <14,-0.0,30>
			texture { LEDTex }
		}
		texture { LEDTex }
	} // end union

#declare Scoreboard =
	union {
		box {
			<0,0.5,0>,<60,10,40>
			texture { WhiteSignTex }
		}
		box {
			<4,0,4>,<60-4,10,40-4>
			texture { BlackSignTex }
		}
		object { SignText }
		cylinder {
			<0,0,-10*Feet>,<0,0,30>,4
			translate <12,5,0>
			texture { WhiteSignTex }
		}
		cylinder {
			<0,0,-10*Feet>,<0,0,30>,4
			translate <60-12,5,0>
			texture { WhiteSignTex }
		}
	} // end union

