
// Glenn's POV-Ray Animation File - Bobsled Shot 110
// created 25-Nov-02
// last update 10-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 30-2*Seconds
/*	 // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .9    //lower value = wider range in focus
		focal_point <0*Feet,12*Feet , 18*Feet >
*/	 // end focal blur
  location  <2*Feet+1*Seconds,6*Feet+.5*Seconds, 18*Feet>
  look_at   <0*Feet,12*Feet , 18*Feet >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <20*Feet,0*Feet, 18*Feet> // scene view
  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"

object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
//object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union
/*
#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		texture { BluePaintTex } 
	} // end union
*/
#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,30*Feet-22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,30*Feet-22,0> }
		texture { BluePaintTex } 
	} // end union

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare HelmetShape =
	difference {
		union {
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		sphere { // inside
			<0,0,0>,4.3
		}
		cylinder { // inside
			<0,0,0.1>,<0,0,-6,>4.3
		}
		box { // cut off back base
			<-8,-8,-6>,<8,8,0>
			rotate x*20
			translate <0,0,-3.2>
		}
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,0,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
	texture { HelmetTex }		
	} // end difference

#declare FaceShield =
	intersection {
		union { // outer
			sphere {
				<0,0,0>,5
			}
			cylinder {
				<0,0,0>,<0,0,-5>,5
			}
		} // end union
		union { // inner
			sphere {
				<0,0,0>,4.8
			}
			cylinder {
				<0,0,0>,<0,0,-5>,4.8
			}
			inverse
		} // end union
		union { // faceplate cutout
			cylinder {
				<0,-6,0>,<0,0,0>,3
				scale <1,1,.6>
				translate <0,0,-1>
			}
			box {
				<-3,-6,0>,<3,0,3>
				scale <1,1,.6>
				translate <0,0,-1>
			}
		} // end union
		texture { FaceShieldTex }
	} // end intersection

#declare FaceS =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "Face.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <8,1,12>
				translate <-4,0,-6>
			}
			finish { ambient .6 }
		}
	}
#declare BackHead =
	sphere {
		<0,0,0>,3.8
		scale <1,1,1>
		texture {
			pigment { color rgb <0.929,0.804,0.702> }
		}
	}

#switch (Seconds)
#range (0,0.3)
#declare ArticulatedHelmet =
	union {
		object { HelmetShape }
		object { FaceS }
		object { FaceShield translate <0,1,-1> rotate x*-60 translate <0,-1,1> }
	} // end union
#break
#range (0.301,1.3)
#declare ArticulatedHelmet =
	union {
		object { HelmetShape }
		object { FaceS }
		object { FaceShield translate <0,1,-1> rotate x*(-60+(60*(Seconds-0.3))) translate <0,-1,1> }
//object { FaceShield }
//object { FaceShield rotate x*-90 translate <0,0,5> }
#declare TAngle =x*(-60+(60*(Seconds-0.3)));
#if ( Debug = 1) #debug concat("Angle: ",str(-60+(60*(Seconds-0.3)),5,3),"\n") #end
#if ( Debug = 1) #debug concat("TAngle: ",str(TAngle.x,5,3),", ",str(TAngle.y,5,3),", ",str(TAngle.z,5,3),", ","\n") #end
	} // end union
#break
#else
#declare ArticulatedHelmet =
	union {
		object { HelmetShape }
		object { FaceS }
		object { FaceShield translate <0,1,-1> rotate x*0 translate <0,-1,1> }
	} // end union
#end

#declare RightArm =
	union {
		cone {
			<0,0,0>,1.3,<0,0,-2*Feet>,2.5
		}
		sphere { // palm glove
			<0,0,0>,1.85
			scale <0.6,1.0,1>
			translate <0,0,1.0>
		}
		sphere { // glove fingers
			<0,0,0>,0.7
			scale <0.6,0.76,1.6>
			rotate y*20
			translate <1,-1,3.0>
		}
		sphere { // glove fingers
			<0,0,0>,0.7
			scale <0.6,0.76,1.3>
			rotate y*20
			translate <1,1,3.0>
		}
		texture { SuitTex }
	} // end union

#switch (Seconds)
#range (0,0.3)
#declare MovingArm =
	object { RightArm rotate y*15 translate <-4,-7,0> }
#break
#range (0.301,1.3)
#declare MovingArm =
	object { RightArm rotate y*15
		rotate x*(-60*(Seconds-0.3))
		translate <-4,-7,0>
		rotate x*(60*(Seconds-0.3))
	}
#break
#else
#declare MovingArm =
	object { RightArm rotate y*15
		rotate x*(-60*(1))
		translate <-4,-7,0>
		rotate x*(60*(1))
		translate <0,-2*(Seconds-1.3),-3*(Seconds-1.3)-5.5*(Seconds-1.3)*(Seconds-1.3)>
	}
#end

#declare BobGuy =
	union {
//	RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(24,7,12,2.4)
			translate <-12,-3.2,-18>
			texture { SuitTex }
		}
		cylinder { // lower neck
			<0,0,-12>,<0,0,-4.5>,3.2
			scale <1,.6,1>
			texture { pigment { color rgb<1,1,1> } }
		}
		cylinder { // upper neck
			<0,0,-6>,<0,0,0>,2.8
			scale <1,.6,1>
			rotate x*-18
			translate <0,2,-2>
			texture { pigment { color rgb<1,1,1> } }
		}
	} // end union

#declare HelmetGroup =
	union {
		object { ArticulatedHelmet }
		object { MovingArm }
		object { BobGuy }
	} // end union

#include "Scoreboard.inc"

//===============================================
//             Object Placement
//===============================================

//object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }
object { Scoreboard scale 1.4 translate <-6.5*Feet,40*Feet,16*Feet> }

//object { BobsledS rotate z*90 translate <0,4*Feet,13*Feet> }
object { HelmetGroup translate <0,12*Feet,18*Feet> }
