
// Glenn's POV-Ray Animation File - Bobsled Shot 135
// created 27-Dec-02
// last update 2-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

#declare NewOrigin = <-80*Feet,-80*Feet,6*Feet>;
#declare SBPos = NewOrigin + <0,-4*Feet*Seconds,0>;

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  angle 60-3*Seconds
  location  SBPos+<-1*Feet,-3*Feet,22>
//  location  SBPos+<-1*Feet,-3*Feet,28-2*Seconds>
  look_at   SBPos+<0,0,12-3*Seconds>
//  look_at   SBPos+<0,0,10-2.5*Seconds>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <20*Feet,0*Feet, 18*Feet> // scene view
  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare ConcreteBlockTex =
	texture {
		pigment { color rgb<.86,.88,.89>*1.3 }
//pigment { rgb<1,1,1> }
//		finish { ambient .2 specular .4 roughness 0.12 }
//		finish { ambient 0.2 diffuse 0.5 specular 0.13 roughness 0.24 }
		finish { ambient 0.63 diffuse 0.1 specular 0.13 roughness 0.16 } // no shadows
	}

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
/*
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		texture { BluePaintTex } 
	} // end union
*/

//object { Plain rotate x*-17 translate -LocalOrigin }
//object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"


#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,30*Feet-22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,30*Feet-22,0> }
		texture { BluePaintTex } 
	} // end union

#declare LowerFloor =
	union {
		difference {
			box {
				<-30*Feet,0,-10*Feet>,<0*Feet,20*Feet,10*Feet>
			}
			box { // window
				<-6,0,0>,<1,4*Feet,3*Feet>
				translate <0,3*Feet,48>
			}
		} // end difference
		box {
			<-1,0,-10*Feet>,<3.3*Feet,10*Feet,7*Feet>
			translate <0,10*Feet,0>
		}
		texture { ConcreteBlockTex }
	} // end union
#declare UpperFloor =
	union {
		box {
			<-18*Feet,0,0>,<0,12*Feet,9*Feet>
		}
		texture { ConcreteBlockTex }
	} // end union

#declare StartingBuilding =
	union {
		object { LowerFloor }
		object { UpperFloor translate <0,-24,10*Feet> }
	} // end union

#declare BigSign =
	union {
		box {
			<0,0,0>,<16*Feet,2*Feet,8*Feet> // backdrop
		}
		cylinder { <0,0,-50>,<0,0,3*Feet>,5 translate <3*Feet,18,0> }
		cylinder { <0,0,-50>,<0,0,3*Feet>,5 translate <16*Feet-3*Feet,18,0> }
		texture {
			pigment { color rgb<1,1,1> }
			finish { ambient 0.2 specular 0.4 roughness 0.05 }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "WCsign.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <14*Feet,1,6*Feet>
				translate <1*Feet,0,1*Feet>
			}
			finish { ambient .6 }
		}
	} // end union

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet>+<-40*Feet,0,0> }
object { StartingGround translate <0,0,13*Feet>+<-40*Feet,0,0> }
object { Pavilion translate <0,30*Feet,13*Feet>+<-40*Feet,0,0> }
object { StartingBuilding scale <-1,1,1> rotate z*40 translate <-60*Feet,-1*Feet,5*Feet>+<-40*Feet,0,0> }
object { BigSign translate <-40*Feet,-15*Feet,8*Feet>+<-40*Feet,0,0> }


//===============================================
//             Objects
//===============================================

#declare RS = seed(60371);

#declare SnowballGround =
	union {
		box { <-40*Feet,-40*Feet,-20*Feet>,<-1*Feet,100*Feet,0> }
		box { <1*Feet,-40*Feet,-20*Feet>,<40*Feet,100*Feet,0> }
		#declare SCount = 1;
		#while (SCount < 20)
			sphere {
				<0,0,0>,.5+rand(RS)*4
				scale <0.8+rand(RS)/2,0.8+rand(RS)/2,1>
				translate <-4*Feet+rand(RS)*8*Feet,-12*Feet+rand(RS)*24*Feet,rand(RS)*3>
			texture { SnowyTex scale 0.3 }
			}
			#declare SCount = SCount + 1;
		#end

		texture { SnowyTex }
	} // end union
#declare SBHollowGround =
	box {
		<-1*Feet,-40*Feet,-20*Feet>,<1*Feet,100*Feet,0>
		texture { SnowyTex }
	}
		
#declare StaticPathArray = array [20+int(Seconds*4)][2]
#declare SBF = 0;
#while (SBF < 20+int(Seconds*4))
	#declare StaticPathArray[SBF][0]=<-0.5+rand(RS)*1.0,18*Feet-SBF*Feet,rand(RS)>;
	#declare ThisRand = 1+rand(RS)*4+Seconds;
	#declare StaticPathArray[SBF][1]=<ThisRand,ThisRand,ThisRand>;
	#declare SBF = SBF + 1;
#end

#declare SBHollowPath =
	union {
		sphere_sweep {
			b_spline
			20+int(Seconds*4),
			#declare SBF = 0;
			#while (SBF < 20+int(Seconds*4))
				StaticPathArray[SBF][0],StaticPathArray[SBF][1].x
				#declare SBF = SBF + 1;
			#end
		}
//		sphere {
//			<0,-4*Feet*Seconds,0>,5
//		}
		texture { SnowyTex }
	} // end union

#declare SBGroundPath =
//union { // test
	difference {
		object { SBHollowGround }
		object { SBHollowPath }
	} // end difference

#declare GrowingSnowball =
	union {
		sphere { // main
			<0,0,0>,3+2*Seconds
		}
		#declare SS = 0;
		#while (SS<Seconds)
			sphere {
				<0,0,0>,1.4+rand(RS)*0.6
				translate <0,0,-2-2*Seconds>
				rotate y*(360*rand(RS))
				rotate z*(360*rand(RS))
			}
			#declare SS = SS + 0.02;
		#end
		texture { BrightSnowyTex scale 0.3 }
		rotate x*360*Seconds
		translate <0,0,1.3+2*Seconds>
	} // end union

//===============================================
//             Object Placement
//===============================================

//object { StartingGround translate <0,0,13*Feet> }
//object { Pavilion translate <0,30*Feet,13*Feet> }

object { SnowballGround translate NewOrigin }
object { SBGroundPath translate NewOrigin }
object { GrowingSnowball translate SBPos }

