
// Glenn's POV-Ray Animation File - Bobsled Shot 150
// created 30-Nov-02
// last update 2-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 15
  location  <8*Feet,9*Feet, 21*Feet>
  look_at   <1*Feet,6*Feet , 15*Feet >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <20*Feet,0*Feet, 18*Feet> // scene view
  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		texture { BluePaintTex } 
	} // end union

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare SideHandle =
	intersection {
		cylinder {
			<-2,0,0>,<2,0,0>,12
		}
		cylinder {
			<-1.2,0,0>,<1.2,0,0>,11.2
			inverse
		}
		box {
			<-0.7,-13,-4>,<0.7,0,8>
		}
//		texture { GlossyBlack }
			texture { pigment { color rgb<0.1,0.13,0.13> } }
	} // end intersection

#declare SlottedSledS =
	difference {
		object { BobsledS }
		box {
			<-0.7,-13,-4>,<0.7,0,8>
			texture { pigment { color rgb<0,0,0> } }
			translate <40,0,16>
		}
	} // end difference
/*
#declare SledGroup =
	union {
		object { SlottedSledS }
		object { SideHandle
			translate <0,10,-6> rotate x*-90 translate <0,-10,6>
			translate <40,0,16>
		}
	} // end union
*/
#declare RightArm = // origin at wrist, arm points up, palm faces +x
	union {
		cone {
			<0,0,0>,1.3,<0,0,-2*Feet>,2.5
		}
		sphere { // palm glove
			<0,0,0>,1.85
			scale <0.6,1.0,1>
			translate <0,0,1.0>
		}
		sphere { // glove fingers
			<0,0,0>,0.9
			scale <0.76,0.86,1.2>
			rotate y*50
			translate <1,-1,2.3>
		}
		sphere { // glove fingers
			<0,0,0>,0.9
			scale <0.76,0.86,1.0>
			rotate y*50
			translate <1,1,2.3>
		}
		texture { SuitTex }
	} // end union
#declare LeftArm =
	object { RightArm scale <1,-1,1> }

#declare SledGroup =
	union {
		object { SlottedSledS }
		object { SideHandle
			translate <0,10,-6> rotate x*-90 translate <0,-10,6>
			translate <40,0,16>
		}
		object { RightArm
			rotate z*180
			rotate y*-112
			rotate z*2
			translate <41,-14,23.8>
		}
		object { LeftArm
			rotate z*180
			rotate y*-116
			rotate z*-19
			translate <41,-18,23.8>
		}
	} // end union


//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }

#if (Seconds < 0.3 )
	object { SledGroup rotate z*90 translate <0,4*Feet-4*Seconds-4*(Seconds*Seconds),13*Feet> }
#else
	object { SledGroup rotate z*90 translate <0,4*Feet-4*Seconds-4*(Seconds*Seconds)-40*((Seconds-0.3)*(Seconds-0.3)*(Seconds-0.3)),13*Feet> }
#end
