
// Glenn's POV-Ray Animation File - Bobsled Shot 160
// created 30-Nov-02
// last update 11-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 22
  location  <8*Feet,5*Feet, 14*Feet>
  look_at   <1*Feet,5*Feet , 13*Feet >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
    direction z*50
  location  <2*Feet, 50*Feet, 140*Feet> // overhead
  look_at   <3*Feet, -0*Feet, 0*Feet >
//  location  <20*Feet,0*Feet, 18*Feet> // scene view
//  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare BootTex =
	texture {
		pigment { color rgb<.06,.08,.19> }
		finish { phong 0.9 phong_size 60 }
	}

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,0> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		texture { BluePaintTex } 
	} // end union

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare SideHandle =
	intersection {
		cylinder {
			<-2,0,0>,<2,0,0>,12
		}
		cylinder {
			<-1.2,0,0>,<1.2,0,0>,11.2
			inverse
		}
		box {
			<-0.7,-13,-4>,<0.7,0,8>
		}
//		texture { GlossyBlack }
			texture { pigment { color rgb<0.1,0.13,0.13> } }
	} // end intersection

#declare SlottedSledS =
	difference {
		object { BobsledS }
		box {
			<-0.7,-13,-4>,<0.7,0,8>
			texture { pigment { color rgb<0,0,0> } }
			translate <40,0,16>
		}
	} // end difference

#declare SledGroup =
	union {
		object { SlottedSledS }
		object { SideHandle
			translate <0,10,-6> rotate x*-90 translate <0,-10,6>
			translate <40,0,16>
		}
	} // end union

#declare PantLeg =
	union {
		cone {
			<0,0,0>,2.1,<0,0,20>,2.8
		}
		torus {
			2.1-0.4,0.4
			rotate x*90
		}
		cylinder {
			<0,0,0>,<20,0,0>,3
			translate <0,0,20>
		}
		texture { SuitTex }
	} // end union
#declare BootTop =
	union {
		sphere {
			<0,0,0>,6.0
			scale <1,0.4,0.5>
			translate <6.0,0,0>
			rotate y*-12
		}
		cone {
			<0,0,0>,1.3,<0,0,6>,2.0
			translate <5.5*2,0,0>
		}
	} // end union
#declare BootSoleCutter =
	union {
		box { <-1,-4,-6>,<14,4,0> }
		box { <-10,-4,-6>,<7,4,2> rotate y*30 }
	}
#declare Boot =
	difference {
		object { BootTop }
		object { BootSoleCutter }
		texture { BootTex }
	} // end difference
#declare LowerLegGroup = // toes at origin, heel in +X, leg into +Z
	union {
		object { Boot }
		object { PantLeg translate <5.5*2,0,4> }
	} // end union

#macro RunningLegCycle(CurrentTime,TouchdownTime)
	#local TDT = TouchdownTime;
	#local GroundDuration = 0.06;
	#local GD = GroundDuration;
	#switch (CurrentTime)
	#range (0,TouchdownTime)
		object { LowerLegGroup rotate y*(-30) translate z*(200*(TDT-CurrentTime)) }
	#break
	#range (TouchdownTime,TDT+GroundDuration)
		object { LowerLegGroup rotate y*(-30-(CurrentTime-TDT)*200) translate <CurrentTime,0,0> }
	#break
	#range (TDT+GroundDuration+0.001,TDT+GroundDuration+0.5)
		object { LowerLegGroup
			rotate y*(-30-GD*200)
			translate <((CurrentTime-TDT-GD)-GD)*-60,0,((CurrentTime-TDT-GD)-GD)*20>
		}
	#break
	#else
//#if ( Debug = 1) #debug concat("ThirdGroup ",str(Seconds,5,3),"\n") #end
		object { LowerLegGroup rotate y*(-30) translate z*30 } // temp
	#end
#end

//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }

object { SledGroup rotate z*90 translate <0,4*Feet-18*Seconds-4*(Seconds*Seconds)-1.4*(Seconds*Seconds*Seconds),13*Feet> }

object { RunningLegCycle(Seconds,1.1) rotate z*90 translate <26,5*Feet+14,13*Feet-3> } // driver rear leg
object { RunningLegCycle(Seconds,1.6) rotate z*90 translate <20, 5*Feet-8,13*Feet-3> } // driver main leg

object { RunningLegCycle(Seconds,2.5) rotate z*90 translate <-3,5*Feet+8,13*Feet-3> } // brakeman
object { RunningLegCycle(Seconds,2.9) rotate z*90 translate <3,5*Feet-6,13*Feet-3> } // brakeman


