
// Glenn's POV-Ray Animation File - Bobsled Shot 200
// created 4-Dec-02
// last update 4-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <400*Feet,880*Feet,0>; // center of turn 1
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

#declare SledPos = <30*Feet,0,0>;
#declare SledPos = vrotate (SledPos,z*-90*(Seconds/1.3));

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 42
  location  <10*Feet,0, 12*Feet>
  look_at   SledPos+<0,4*Feet,2*Feet+3*Feet*Seconds>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 11
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <-5*Feet,-30*Feet, 19*Feet> // scene view
  look_at   <0*Feet,10*Feet , 15*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <24*Feet,0*Feet,2*Feet> }
object { TrackLight translate <0*Feet,-24*Feet,2*Feet> }
object { TrackLight translate <16*Feet,-16*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"


//===============================================
//             Object Placement
//===============================================

#switch (Seconds)
#range (0,0.6)
object { BobsledSFull
	rotate <-15*(Seconds/0.6),0,90>
	translate <30*Feet,0,2*Feet>
	rotate z*-90*(Seconds/1.2736)
}
#break
#range (0.601,1.2736)
object { BobsledSFull
	rotate <-15+15*((Seconds-0.6)/0.6736),0,90>
	translate <30*Feet,0,2*Feet>
	rotate z*-90*(Seconds/1.2736)
}
#break
#else
object { BobsledSFull
	rotate <0,0,0>
	translate <0*Feet-37*Feet*(Seconds-1.2736),-30*Feet,2*Feet>
}
#end
