
// Glenn's POV-Ray Animation File - Bobsled Shot 270
// created 6-Dec-02
// last update 5-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <120*Feet,520*Feet,0>; // center of turn 7
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "AnimMacros.inc"
#include "TrackMaker.inc"

#declare CamLook = <50*Feet,0,2*Feet>;
#declare CamLook = vrotate (CamLook,z*(-10-176*(Seconds/3.2)-Shake(2,43321,Seconds/3.2)*3));

#if ( Debug = 1) #debug concat("CamLook:","<",str(CamLook.x,5,0),",",str(CamLook.y,5,0),",",str(CamLook.z,5,0),">","\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 30
  location  <0*Feet,0*Feet,20*Feet>
  look_at   CamLook + <0*Feet,0,8*Feet> 
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  CamLook + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   CamLook +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <40*Feet,60*Feet,2*Feet> }
object { TrackLight translate <40*Feet,0*Feet,2*Feet> rotate z*0 }
object { TrackLight translate <40*Feet,0*Feet,2*Feet> rotate z*-90 }
object { TrackLight translate <40*Feet,0*Feet,2*Feet> rotate z*-180 }
object { TrackLight translate <40*Feet,0*Feet,2*Feet> rotate z*-270 }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin rotate x*8 }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> rotate x*8 }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"


//===============================================
//             Object Placement
//===============================================

// speed 73 ft/s
object { BobsledSFull
	rotate z*90
	translate <0,0,-6*Feet> // set on turn
	rotate <0,-80+Shake(3,21773,Seconds/2.7)*10,0>
	translate <50*Feet,0,6*Feet+6*Feet+2*Feet>
	rotate z*(-10-190*(Seconds/3.2))
}
