
// Glenn's POV-Ray Animation File - Bobsled Shot 300
// created 10-Dec-02
// last update 10-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,400*Feet,0>; // end of straight 9
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

// 95 ft/sec, half speed slo-mo
#declare SledPos = <0,60*Feet,2*Feet>;
#declare SledPos = SledPos + <0,-50*Feet*Seconds,0>;

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 15-8*Seconds
  location  SledPos + <-1*Feet,-8*Feet,3*Feet>
  look_at   SledPos + <0,3*Feet,32>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare BugEye =
	sphere {
		<0,0,0>,0.6
		texture {
			pigment {
				spherical
				color_map {
					[ 0.00 rgb<1,1,1> ]
					[ 0.70 rgb<1,1,1> ]
					[ 0.75 rgb<.01,.01,.41> ] // blue
					[ 0.93 rgb<.01,.01,.41> ] // blue
					[ 0.95 rgb<.01,.01,.01> ] // black
				}
				translate <0,-0.6,0>
			}
			#if ( Seconds < 0.4 ) finish { ambient 0.2 specular 0.93 roughness 0.04 }
			#else finish { ambient 0.2+(0.6*(Seconds-0.4)) specular 0.93 roughness 0.04 }
			#end
		}
	}

//===============================================
//             Object Placement
//===============================================


// speed 95 ft/s
object { BobsledSFull
	rotate z*90
	translate SledPos
}

object { BugEye
	scale 1
	rotate z*3
	translate SledPos + <-1.2,58.6-1.4*Seconds,30.9>
}
object { BugEye
	scale 1
	rotate z*3
	translate SledPos + < 1.2,58.6-1.4*Seconds,31.0>
}


