
// POV-Ray Object File - Track Lights
// created 25-Nov-02
// last update 25-Nov-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "TrackLights.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// TrackLight
//
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare LightBlueTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare LitLightTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 36 }
	}

//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

#declare TrackLight =
	union {
		box { // base
			<-10,-10,-30*Feet>,<10,10,30>
			texture { LightBlueTex }
		}
		cone { // stand
			<0,0,0>,6,<0,0,40*Feet>,2
			texture { LightBlueTex }
		}
		box { // light
			<-6,-6*Feet,0>,<6,6*Feet,6>
			translate <0,0,40*Feet>
			texture { LitLightTex }
		}
	} // end union

