
// POV-Ray Object File - Bobsled Track
// created 18-Nov-02
// last update 30-Nov-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "TrackMaker.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CircularSection(Radius)
// FlatTrack(Length)
// TrackTurn(Radius,TurnAngle)
// TotalTrack
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Sky is up

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================




//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare IcyTex =
	texture {
//		pigment { color rgb <0.895,0.892,0.994>*1.20 } // pretty good
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<0.895,0.892,0.994>*1.20 ]
				[ 1.0 rgb<0.895,0.892,0.994>*0.90 ]
			}
			scale 8
		}
		normal { bumps 0.1 scale 12 }
		finish { ambient 0.63 diffuse 0.1 specular 0.53 roughness 0.24 }
	}


//===============================================
//             Macros
//===============================================

#declare StraightSectionWall =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "SidewallHF.png"
		smooth
		water_level .02
		scale <40*Feet,-0.6*Feet,4*Feet> // extrude into -Y
		texture { IcyTex }
	}
#declare SidewallSection =
	union {
		object { StraightSectionWall translate <0,-3.5*Feet,-6> }
		object { StraightSectionWall scale <1,-1,1> translate <0,-3.5*Feet,-6> }
		object { StraightSectionWall scale <-1,1,1> translate <40*Feet,3.5*Feet,-6> }
		object { StraightSectionWall scale <-1,-1,1> translate <40*Feet,3.5*Feet,-6> }
		box { // base
			<0,-3.5*Feet,-6>,<40*Feet,3.5*Feet,0>
			texture { IcyTex }
		}
	} // end union

#macro FlatTrack(length)
	#local SCountMax = length/(40*Feet);
	#local ExtraLength = mod(length,40*Feet);
	#local SCount = 0;
//#debug concat("SCountMax is:",str(SCountMax,5,3),"\n")
//#debug concat("SCount is:",str(SCount,5,3),"\n")
	union {

	#while ( SCount < SCountMax-1 )
		object { SidewallSection translate x*SCount*40*Feet }
		#local SCount = SCount + 1;
	#end

		object { SidewallSection
			clipped_by { box { <-1*Feet,-5*Feet,-2*Feet>,<ExtraLength,5*Feet,5*Feet> } }
			translate x*int(length/(40*Feet))*40*Feet
		}

	} // end union
#end

#declare WideTrackWall =
	union {
		object { StraightSectionWall }
		object { StraightSectionWall translate <40*Feet,0,0> }
	} // end union
#declare WideTrack =
	union {
		object { WideTrackWall rotate z*12 translate <0,3.5*Feet,-6> }
		object { WideTrackWall scale <1,-1,1> rotate z*-12 translate <0,-3.5*Feet,-6> }
		difference {
			box { // base
				<0,-40*Feet,-12>,<100*Feet,40*Feet,0>
			}
			box {
				<0,0*Feet,-13>,<140*Feet,40*Feet,1>
				rotate z*12
				translate <0,3.5*Feet,0>
			}
			box {
				<0,-40*Feet,-13>,<140*Feet,0*Feet,1>
				rotate z*-12
				translate <0,-3.5*Feet,0>
			}

			texture { IcyTex }
		} // end difference
	} // end union

/*
#declare MySidewall =
	difference {
//		object { SidewallSection }
		box { <0*Feet,-2.5*Feet,-1*Feet>,<40*Feet,2.5*Feet,4*Feet> texture { IcyTex }
			clipped_by { box { <8*Feet,-5*Feet,-2*Feet>,<41*Feet,5*Feet,5*Feet> } } }
	} // end difference
*/
#declare MySidewall = // thisis justa test
//	intersection {
	union {
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "SidewallHF.png"
		smooth
		water_level .02
		scale <8*Feet,1*Feet,4*Feet> // extrude into -Y
		texture { IcyTex }
	}
	cylinder {
		<0,-5*Feet,0>,<0,5*Feet,0>,20
		translate <4*Feet,0,1*Feet>
		texture { IcyTex }
	}
	} // end difference

#macro CircularSection(Radius)
	union {
		difference { // main track
			torus { Radius,7*Feet }
			torus { Radius,6*Feet }
			cylinder { <0,-8*Feet,0>,<0,8*Feet,0>,Radius }
			texture { IcyTex scale <1.3,0.6,1.3> }
		} // end difference
		difference { // floor
			cylinder { <0,6*Feet,0>,<0,7*Feet,0>,Radius }
			cylinder { <0,5*Feet,0>,<0,8*Feet,0>,Radius-4*Feet }
		} // end difference
		difference { // inner wall
			cylinder { <0,3*Feet,0>,<0,10*Feet,0>,Radius-4*Feet }
			cylinder { <0,1*Feet,0>,<0,11*Feet,0>,Radius-5*Feet }
		} // end difference
		texture { IcyTex }
		rotate x*-90
	} // end union
#end

#macro TrackTurn(Radius,TAngle) // right turn, begins at <0,0,0>
	intersection {
//	union {
		object { CircularSection(Radius) }
		#if ( TAngle < 90 )
			intersection {
				box { <0,0,-10*Feet>,<Radius+10*Feet,Radius+10*Feet,10*Feet> texture { IcyTex } }
				box { <0,0,-10*Feet>,<-Radius-10*Feet,Radius+10*Feet,10*Feet> rotate z*(-TAngle) texture { IcyTex } }
			} // end intersection
		#end

		#if ( TAngle >= 90 ) #if ( TAngle <= 180 )
			union {
				box { <0,0,-10*Feet>,<Radius+10*Feet,Radius+10*Feet,10*Feet> texture { IcyTex } } // first 90 deg
				box { <0,0,-10*Feet>,<Radius+10*Feet,Radius+10*Feet,10*Feet> rotate z*(90-TAngle) texture { IcyTex } } // the rest
			} // end union
		#end #end

		#if ( TAngle > 180 )
			union {
				box { <0,-Radius-10*Feet,-10*Feet>,<Radius+10*Feet,Radius+10*Feet,10*Feet> texture { IcyTex } } // first 180 deg
				box { <0,-Radius-10*Feet,-10*Feet>,<Radius+10*Feet,Radius+10*Feet,10*Feet> rotate z*(180-TAngle) texture { IcyTex } } // the rest
			} // end union
		#end
		translate <0,-Radius,6*Feet>
	} // end intersection
#end

//===============================================
//             Objects
//===============================================

#declare P1 =  <430*Feet,880*Feet,0>;
#declare P2 =  <310*Feet,850*Feet,0>;
#declare P3 =  <360*Feet,770*Feet,0>;
#declare P4 =  <390*Feet,700*Feet,0>;
#declare P5 =  <350*Feet,640*Feet,0>;
#declare P6 =  <210*Feet,630*Feet,0>;
#declare P7 =  <170*Feet,520*Feet,0>;
#declare P8 =  <250*Feet,570*Feet,0>;
#declare P9 =  <320*Feet,400*Feet,0>;
#declare P10 = <200*Feet,350*Feet,0>;
#declare P11 = <270*Feet,250*Feet,0>;
#declare P12 = <320*Feet,100*Feet,0>;

#declare S1 =  object { FlatTrack(100*Feet) rotate z*90 rotate x*6 translate P1 }
#declare T1 =  object { TrackTurn(30*Feet,90) rotate z*-90 translate P1 }
#declare S2 =  object { FlatTrack(90*Feet) rotate z*0 translate P2 }
#declare T2 =  object { TrackTurn(40*Feet,180) scale <-1,1,1> translate P2 }
#declare S3 =  object { FlatTrack(50*Feet) rotate z*180 translate P3 }
#declare T3 =  object { TrackTurn(30*Feet,90) translate P3 }
#declare S4 =  object { FlatTrack(40.1*Feet) rotate z*90 translate P4 }
#declare T4 =  object { TrackTurn(40*Feet,45) rotate z*-90 translate P4 }
#declare S5 =  object { FlatTrack(44*Feet) rotate z*45 translate P5 }
#declare T5 =  object { TrackTurn(40*Feet,45) rotate z*-135 translate P5 }
#declare S6 =  object { FlatTrack(110*Feet) rotate z*0 translate P6 }
#declare T6 =  object { TrackTurn(40*Feet,90) scale <-1,1,1> rotate x*-8 translate P6 }
#declare S7 =  object { FlatTrack(70*Feet) rotate z*90 rotate x*0 translate P7+<0,0,6*Feet> }
#declare T7 =  object { TrackTurn(50*Feet,270) rotate z*-90 rotate x*-8 translate P7+<0,0,6*Feet> }
#declare S8 =  object { FlatTrack(130*Feet) rotate z*180 translate P8 }
#declare T8 =  object { TrackTurn(70*Feet,90) translate P8 }
#declare S9 =  object { FlatTrack(100*Feet) rotate z*90 translate P9 }
#declare T9 =  object { TrackTurn(50*Feet,90) rotate z*-90 translate P9 }
#declare S10 = object { FlatTrack(70*Feet) rotate z*0 translate P10 }
#declare T10 = object { TrackTurn(50*Feet,180) scale <-1,1,1> translate P10 }
#declare S11 = object { FlatTrack(70*Feet) rotate z*180 translate P11 }
#declare T11 = object { TrackTurn(50*Feet,90) translate P11 }
#declare S12 = object { FlatTrack(100*Feet) rotate z*90 translate P12 }
#declare T12 = object { TrackTurn(40*Feet,180) scale <-1,1,1> rotate z*90 translate P12 }
#declare S13 = object { FlatTrack(60*Feet) rotate z*90 translate P12+<80*Feet,0,0> }
#declare S14 = object { WideTrack rotate z*90 translate P12+<80*Feet,60*Feet,0> }

#declare TotalTrack =
	union {
		object { S1 }
		object { T1 }
		object { S2 }
		object { T2 }
		object { S3 }
		object { T3 }
		object { S4 }
		object { T4 }
		object { S5 }
		object { T5 }
		object { S6 }
		object { T6 }
		object { S7 }
		object { T7 }
		object { S8 }
		object { T8 }
		object { S9 }
		object { T9 }
		object { S10 }
		object { T10 }
		object { S11 }
		object { T11 }
		object { S12 }
		object { T12 }
		object { S13 }
		object { S14 }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {
	max_trace_level 20
}
	camera {
		perspective
//		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>
		right     <1.33333, 0.0,  0.0>
		angle 14
//		location  <-6, -40*Feet, 12*Feet> // closeup
//		look_at <0,6*Feet,2*Feet>
		location  <-60*Feet, -140*Feet, 60*Feet> // overall
		look_at <0,0*Feet,2*Feet>
//		location  <-6, -400*Feet, 3000*Feet> // helicam
//		look_at <200*Feet,700*Feet,2*Feet>
	}

#declare AreaSun = 0;
#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.581>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*-35 // towards left
  rotate z*1 // behind camera
}

/*
light_source
{ <-100*Feet,0*Feet,500*Feet>, <0.660,0.663,0.671>*1.5
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}

light_source
{ <140*Feet,-120*Feet,130*Feet>, <0.83,0.88,0.93>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
*/
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


//object { SidewallSection scale 1 rotate z*0 translate <0,0,0> }
//object { SidewallSection scale 1 rotate z*0 translate <-40*Feet,0,0> }
//object { SidewallSection scale 1 rotate z*70 translate <-4*Feet,4*Feet,2*Feet> }

//object { FlatTrack(38*Feet) scale 1 rotate z*0 translate <-40*Feet,0,0> }
//object { FlatTrack(45*Feet) scale 1 rotate z*70 translate <-4*Feet,4*Feet,2*Feet> }
//object { FlatTrack(135*Feet) scale 1 rotate z*150 translate <-7*Feet,4*Feet,4*Feet> }

//object { CircularSection(40*Feet) translate <0,0,8*Feet> }
//object { FlatTrack(121*Feet) translate <-121*Feet,40*Feet,0> translate <0,0,1*Feet> }
object { TrackTurn(40*Feet,120) translate <0,0,1*Feet> }
//object { FlatTrack(65*Feet) translate y*40*Feet rotate z*-120 translate <0,0,1*Feet> }

/*
object { MySidewall scale 1 rotate z*0 translate <0,0,0> }
object { MySidewall scale 1 rotate z*70 translate <-4*Feet,4*Feet,2*Feet> }
object { MySidewall scale 1 rotate z*150 translate <-7*Feet,4*Feet,4*Feet> }
*/

//object { TotalTrack translate <0,0,2*Feet> }

#end
