////////////////////// animation time periods //////////////////////
#declare AnimationStartTime = -20;
#declare CirclingTimePeriod = 10;
#declare HammerStartsToSwing = 0; 

#declare GravitationalConstant = 9.8; // meters per sec^2

#declare TorusZPosition = 0;
#declare Elevation = 0; // set the inital value for the rolling surface

////////////// This defines the stone torus ////////////////////////
#declare TorusMajorAxis = .25;
#declare TorusMinorAxis = TorusMajorAxis/3;

//////// about the size of the ramp sytem circle ///////////////////
#declare LampRollOut = 40;                              
#declare NoLampCircleRadius = 10;

///////////////////// plugged in values ////////////////////////////
#declare StartInclineX = 120;      // start here
#declare InclineAngleDegrees = 4;  // go up this steep                                   
#declare InclineLength = 100;      // for how long roadway goes up
#declare PlaneLength = 15;         // how long on the flat spot

#declare RoadThickness = 0.1;
#declare RoadWidth = 2.5;
                               
///////////////////////////// hammer stuff! ////////////////////////
#declare HammerWidth   = 2;
#declare HammerSwingHeight = 2.25 + (TorusMajorAxis + TorusMinorAxis);    // makes arithmetic easier
#declare HammerHeadRadius = 0.25;

#declare HammerMass = 50;
#declare TorusMass = HammerMass;

#declare ArmLength = HammerSwingHeight - (TorusMajorAxis + TorusMinorAxis);
#declare HammerSetBack = -(TorusMajorAxis + TorusMinorAxis) - HammerHeadRadius;      

#declare HammerDropsTorusStartsMoving = sqrt (2 * pi * ArmLength/ GravitationalConstant); 

/////////////////////////// now you can do these Torus calcs //////////////////////////////////////////////////
#declare InitialVelocity = (GravitationalConstant * HammerDropsTorusStartsMoving) * (HammerMass/TorusMass);
#declare InclineTime = StartInclineX/InitialVelocity + HammerDropsTorusStartsMoving; // the hammmer drop is add
///////////////////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////// just for the lamps ////////////////////
#declare LongPipeRadius = 0.6;
#declare HeightOfStraightSection = 24;
#declare LampPostSetout = 0; 
#declare ArcReach = HammerWidth * 2.5;
#declare LampPostZSpot = 0;
#declare HeightOfThickSection = 18;

#declare ScaleFactorHeight = 1.2;                      

///////////////////// misc camera stuff!!!!/////////////////////////
#declare CameraSetBackFactor = 35;
#declare CameraBaseDistance = 4;


#declare CameraCircleLagFactor = 8; // just keep spinning around div by 4-8 to make slower


////////////////////////// generic calcs ///////////////////////////
#declare InclineAngle = InclineAngleDegrees * 2 * pi / 360;

#declare PlaneHeight = InclineLength * sin(InclineAngle);
#declare StartPlaneX =  StartInclineX + InclineLength * cos(InclineAngle);

#declare PlaneVelocity =   sqrt( InitialVelocity*InitialVelocity -  2*GravitationalConstant*PlaneHeight );
                        
#declare SpindleRadius = StartInclineX + InclineLength * cos(InclineAngle) + PlaneLength;  // complex sounding but obvious - use picture to show!

#declare ZoomingInTimePeriod = (HammerStartsToSwing) - (AnimationStartTime + CirclingTimePeriod);
