
#if (clock <= HammerStartsToSwing) 
    #declare HammerAngleDegrees = 0; // straight up
#end

#if (clock > HammerStartsToSwing) 
    #if (clock <= HammerDropsTorusStartsMoving) 
        #declare FallingDistance =  (1/2) * GravitationalConstant * clock*clock; 
        #declare HammerAngleDegrees = (FallingDistance) * 360 / (2 * pi * ArmLength); // convert to Degrees
    #end
#end

#if (clock > HammerDropsTorusStartsMoving) 

     #declare FallingDistance =  pi * ArmLength; 
     #declare HammerAngleDegrees = 180; // convert to Degrees

#end

#declare Swing = union {

// create two bottom 1/2 spheres
sphere {<HammerSetBack 0, -HammerWidth/2> HammerHeadRadius * 3 }
sphere {<HammerSetBack 0, HammerWidth/2> HammerHeadRadius * 3 }


// create two poles
cylinder { <HammerSetBack 0, -HammerWidth/2>, <HammerSetBack HammerSwingHeight, -HammerWidth/2>,  0.1}
cylinder { <HammerSetBack 0, HammerWidth/2>, <HammerSetBack HammerSwingHeight, HammerWidth/2>,  0.1}

// create two poles
sphere {<HammerSetBack HammerSwingHeight, -HammerWidth/2>  HammerHeadRadius  }     // radius of sphere
sphere {<HammerSetBack HammerSwingHeight, HammerWidth/2>  HammerHeadRadius  }     // radius of sphere

// create cross-bar on top
cylinder { <HammerSetBack HammerSwingHeight, -HammerWidth/2>, <HammerSetBack HammerSwingHeight, HammerWidth/2>,  0.1}

}
   
#declare Hammer = union {

// top middle sphere shape - i.e., the pivot of the hammer
sphere { <HammerSetBack HammerSwingHeight, 0> HammerHeadRadius * 0.75}

// swinging arm
cylinder { <HammerSetBack HammerSwingHeight + ArmLength, 0>, <HammerSetBack HammerSwingHeight, 0>,  0.05}

//HammerHead
sphere { <HammerSetBack HammerSwingHeight + ArmLength, 0> HammerHeadRadius }

}

#declare SwingingHammer = union {

object {Swing}
object {Hammer translate <-HammerSetBack,-HammerSwingHeight,0> rotate<0,0, HammerAngleDegrees > translate <HammerSetBack,HammerSwingHeight,0>}


   texture { T_Stone18
   finish { reflection .2 phong 0.3 phong_size 40 }} // altering the reflection properties of the marble which appears to have no default reflection

}





