// Edward Leibnitz - December 7, 2002
// baseanim.pov - basic animation loop for speed project IRTC competition!

global_settings { assumed_gamma 2.2 }

// POV-Ray stuff
#include "colors.inc"
#include "skies.inc" 
#include "textures.inc"
#include "stones.inc" 
#include "metals.inc"

// environmental things                                                                          
#include "GlobalConstants.inc"
#include "Environment.inc" 

// necessary for Ramp system 
#include "RampSystem.inc"
#include "Torus.inc"
#include "Hammer.inc"
#include "ExtraLighting.inc"

// camera last
#include "CameraKeyFillLighting.inc"  

#declare RampTorusHammerSystem = 

union
{
object {RampSystem}
object {SwingingHammer }
object {RollingTorus}

StreetLampSystem ()  // this is a blank parameter macro!
}

#declare FinalView = union {

object {RampTorusHammerSystem translate <-SpindleRadius,0,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *1 ,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *2 ,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *3 ,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *4 ,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *5 ,0>}
object {RampTorusHammerSystem translate <-SpindleRadius,0,0> rotate<0,(360/7) *6 ,0>}

}

object { FinalView translate <SpindleRadius,0,0> }

cylinder { <SpindleRadius, 0, 0>, <SpindleRadius,PlaneHeight,0>,  3
  texture { T_Stone9
  finish { reflection 0.2 phong 0.1 diffuse 0 brilliance 0  specular 0  phong_size 5 }} // altering the reflection properties of the marble which appears to have no default reflection
}
