#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "skies.inc"

background { SkyBlue }
sky_sphere { S_Cloud5 }

light_source { <-300, 25, 0> color White }
light_source { <-150, 120, 0> color White }
light_source { <0, 25, 0> color White }
light_source { <150, 120, 0> color White }
light_source { <300, 25, 0> color White }

plane {
    y, 0
    pigment { checker color rgb<0,0.3,0.3> color rgb<0.4,0,0> scale 5 }
}


// The moving spheres.
sphere { <-200, 1, 0> , 1
    texture {
        pigment { color White }
        finish { reflection .6 specular .1 diffuse .17 }
    }
    translate <295*clock, 0, 0>
}
sphere { <-200, 1, 5> , 1
    texture {
        pigment { color Green }
        finish { reflection .6 specular .1 diffuse .17 }
    }
    translate <282*clock, 0, 0>
}
sphere { <-200, 1, -5> , 1
    texture {
        pigment { color Yellow }
        finish { reflection .6 specular .1 diffuse .17 }
    }
    translate <270*clock, 0, 0>
}

#switch (clock)
#range ( 0, .7 )
    camera {
        location <-40, .7, 2.5>
        look_at <-200, 0, 0>
    }
#break
#range ( .64, 1.38 )
    #declare ElseClock = clock - 1;
    camera {
        location <30, 1.3, 0>
        look_at <500, 1, 0>
        translate <330*ElseClock, 2.5*ElseClock, 0> 
    }
#break
#else
    camera {
        location <150, 2.7, 0>
        look_at <500, 1, 0>
    }
#end


// lane markers
sphere {
    <-25, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-25, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-50, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-50, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-75, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-75, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-100, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-100, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-125, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-125, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-150, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-150, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-175, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-175, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-200, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-200, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-225, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-225, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-250, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-250, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-275, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <-275, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <0, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <0, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <25, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <25, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <50, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <50, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <75, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <75, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <100, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <100, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <125, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <125, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <150, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <150, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <175, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <175, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <200, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <200, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <225, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <225, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <250, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <250, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <275, 0, 10>, .25
    texture {
        pigment { color Yellow }
    }
}
sphere {
    <275, 0, -10>, .25
    texture {
        pigment { color Yellow }
    }
}

// finish line
sphere {
    <300, 0, 10>, 2
    texture {
        pigment { checker color White color Black }
    }
}
sphere {
    <300, 0, -10>, 2
    texture {
        pigment { checker color White color Black }
    }
}

