

// Cockpit forward view

#include "carlook.inc"

#declare T_panel = texture{
  pigment{color rgb 1}
  finish{ambient 0.5 diffuse 0.5 phong 3 phong_size 9}
  normal{bump_map{png "panel.png" bump_size 4} rotate<0,-90,0> scale 0.01}
};

#macro make_wheel(col_pos, turn)

 union{
       torus{0.025, 0.004 rotate<0,0,90> 
             texture{pigment{color rgb 0.2}
                     finish{ambient 0.3 diffuse 0.9 phong 1 phong_size 15}
                     normal{bumps 0.4 scale 0.003}
                    }
            }
       difference{
                  box{<-0.002,-0.025,-0.0026><0,0.025,0.0026>}
                  union{
                        cylinder{<-0.003,-0.016,0><0.01,-0.016,0>,0.0015}
                        cylinder{<-0.003,-0.012,0><0.01,-0.012,0>,0.0016}
                        cylinder{<-0.003,-0.008,0><0.01,-0.008,0>,0.0017}
                        
                        cylinder{<-0.003,0.016,0><0.01,0.016,0>,0.0015}
                        cylinder{<-0.003,0.012,0><0.01,0.012,0>,0.0016}
                        cylinder{<-0.003,0.008,0><0.01,0.008,0>,0.0017}
                        
                        pigment{color rgbt<1,1,1,1>}
                       }
                  texture{pigment{color rgb 1}
                          finish{ambient 0.3 diffuse 0.7 phong 2 phong_size 30}}
                  }

       rotate<-turn,0,0>
       translate col_pos
       }

  // Column
  cylinder{<col_pos.x-0.22,col_pos.y,col_pos.z> col_pos, 0.004
           texture{pigment{color rgb 1}finish{ambient 0.4 diffuse 0.6 phong 1}}
          }
  sphere{<0,0,0>,0.006 scale<0.25,1,1> translate col_pos
         texture{pigment{color rgb 1}
                 finish{ambient 0.4 diffuse 0.7 phong 1 phong_size 30}} }

#end

#macro make_dial( reading )

  #local rad = 0.008;
  #local rim_size = 0.001;
  #local bolt_T = texture{pigment{color rgb<1,1,1>}
                          finish{ambient 0.3 diffuse 0.6 phong 1 phong_size 30}};
  #local rim_T = texture{pigment{color rgb<1,1,1>}
                         finish{ambient 0.3 diffuse 0.6 phong 1 phong_size 30}};

  union{ 
        // Bolts
        sphere{<0,-rad,-rad>, rim_size*1.5 texture{bolt_T}}  
        sphere{<0,-rad, rad>, rim_size*1.5 texture{bolt_T}}
        sphere{<0, rad, rad>, rim_size*1.5 texture{bolt_T}}
        sphere{<0, rad,-rad>, rim_size*1.5 texture{bolt_T}}
  
        // Rim
        torus{rad, rim_size rotate<0,0,90>texture{rim_T}}

        // Face
        disc{<0,0,0><1,0,0> 1
             texture{
                     pigment{image_map{png "dial.png"}
                             rotate<90,0,90> scale 2 translate<0,-1,-1>
                            }
                    finish{ambient 1}
                    }
             scale <1,rad,rad>
             translate<0.0001,0,0>
            }

       // Needle
       sphere{<0,0,0>, 0.9*rim_size scale<1,2,2>texture{rim_T}}
       cone{<0,0,0>, 0.9*rim_size <0,0.7*rad,0>, 0.3*rim_size
            rotate<(250 - reading*320),0,0>
            texture{pigment{color rgb 1}finish{ambient 0.9 diffuse 1}}
           }
       }

#end


#macro make_light( position, col )

 #local rim_T = texture{pigment{color rgb<1,1,1>}
                         finish{ambient 0.3 diffuse 0.6 phong 1 phong_size 30}};
  #local rad = 0.003;
  #local h = 0.0015;
  union{
        cylinder{<-0.0001,0,0><h,0,0>, rad texture{rim_T}}
        sphere{<h,0,0>,0.8*rad texture{pigment{color rgb col}finish{ambient 1}}}
       
        box{<-0.0001,-0.9*rad,-0.008><0.0001,0.9*rad,-0.005>
            texture{pigment{color rgb 0.5}finish{ambient 0.4 diffuse 0.8}}}

        translate position
       }
#end

#macro flash_col( flash_time )

  #if (flash_time=0)
    #local col = <0.4,0.2,0.1>;
  #else
      #if ( mod(div(frame_number,flash_time),2) )
           #local col = <1,0,0>;
      #else
           #local col = <0.4,0.2,0.1>;
      #end
  #end

 (col)

#end


#macro make_cockpit_foreward_view( position, thrust, turn )

union{

  difference{

    // Lower body
    cylinder{<-0.7,0,0.5><1.5,0,0.5>,0.25 texture{car_body_texture}}

    // cockpit
    box{<0.9,-0.075,0.3><1.5,0.075,0.8> texture{T_panel}
 
        }
  }
 
  // sides
  box{<0.91,-0.0755,0.4><1.49,-0.068,0.735>
         texture{pigment{color rgb 0.5}
               finish{ambient 0.3 diffuse 0.7 phong 0.9 phong_size 5}
               normal{bumps 0.5 scale 0.001}}

   }
  box{<0.91, 0.0755,0.4><1.49, 0.068,0.735>
         texture{pigment{color rgb 0.5}
               finish{ambient 0.3 diffuse 0.7 phong 0.9 phong_size 5}
               normal{bumps 0.5 scale 0.001}}

   }

  // Nose cone
  sphere{<0,0,0>,1 scale<2,0.25,0.25> translate<-0.7,0,0.5>
         texture{car_body_texture}
         clipped_by{plane{y,-0.8}}
        }


  // Join body to cockpit
  disc{<0.902,0,0.5><1,0,0>, 0.251, 0.246
       texture{pigment{color rgb<0.4,0.4,0.4>}
               finish{ambient 0.4 diffuse 0.7 phong 0.8 phong_size 20}
               normal{bumps 0.2 scale 0.001}
               } 
      }


  // Canopy
   sphere{<0,0,0>,1 clipped_by{plane{-z,-0.0}}
           scale<0.8,0.19,0.1> translate<1.6,0,0.72> 
             texture{pigment{color rgbt<1,1,1,1>}
                     finish{//ambient 0.1 diffuse 0.5 phong 4 phong_size 10 
                             reflection 0.2}
                    }
          hollow 
          }

  // ---------------------------------------------------
  // Controls

  // Wheel
  make_wheel(<0.92,0,0.71>, turn )

  // Dials
  #local d0 = make_dial(pow(thrust, 0.8));
  object{d0 rotate<-90,0,0>scale <1,0.8,0.8> translate<0.9,-0.0405,0.73>}

  #local d1 = make_dial(pow(thrust, 1.2));
  object{d1 rotate<-90,0,0>scale <1,0.8,0.8> translate<0.9,0.0405,0.73>}

  #local d2 = make_dial(pow(thrust, 0.7));
  object{d2 translate<0.9,0.057,0.71>}
  object{d2 translate<0.9,-0.057,0.71>}

  #local d3 = make_dial(pow(thrust, 1.7));
  object{d3 translate <0.9,0.057,0.69>}
  object{d3 translate <0.9,-0.057,0.69>}

  // Lights
  #if (thrust > 0.85)
      #declare col = flash_col(6);
  #else
      #declare col = flash_col(0);
  #end
  make_light( <0.9,-0.065,0.73>, col)
  make_light( <0.9,-0.056,0.73>, col)

  #if (thrust > 0.85)
      #declare col = flash_col(7);
  #else
      #declare col = flash_col(0);
  #end
  make_light( <0.9,0.065,0.73>, col)
  make_light( <0.9,0.056,0.73>, col)

  #if (thrust > 0.85)
      #declare col = flash_col(5);
  #else
      #declare col = flash_col(0);
  #end
  make_light( <0.9,-0.021,0.74>, col)
  make_light( <0.9, 0.021,0.74>, col)


  translate<position,0,0>

  hollow

}

#end

// ------------------------------------------------

// Cockpit rear view

#macro make_cockpit_rear_view( car_x )

  #local Tpanel = texture{
    pigment{color rgb 1}
    finish{ambient 0.3 diffuse 2 phong 3 phong_size 5}
    normal{bump_map{png "panel.png" bump_size 3} rotate<0,-90,0> scale 0.02}          
  };
  
  union{

   // upper body
   disc{<1.5,0,0.73><-1,0,0>, 0.11 texture{Tpanel}}
   torus{ 0.1045, 0.005  rotate<0,0,90> clipped_by{plane{-z,0.01}}
         translate<1.5,0,0.73>
         texture{pigment{color rgb 0.2}
                 finish{ambient 0.3 diffuse 0.7 phong 0.9 phong_size 5}
                }
     }

   // lower body
   difference{
     cylinder{<-0.7,0,0.5><3.07,0,0.5>,0.25 texture{car_body_texture}}
     box{<0.9,-0.1,0.3><1.501,0.1,0.8>texture{Tpanel}}
   }
   box{<0.91,-0.101,0.31><1.49,-0.09,0.721>
         texture{pigment{color rgb 0.5}
               finish{ambient 0.3 diffuse 0.7 phong 0.9 phong_size 5}
               normal{bumps 0.5 scale 0.001}}

   }
   box{<0.91, 0.101,0.31><1.49, 0.09,0.721>
     texture{pigment{color rgb 0.3}
               finish{ambient 0.3 diffuse 0.7 phong 0.9 phong_size 5}
              normal{bumps 0.5 scale 0.001}}
     }


   // Tail fin
   cone{<0,0,-0.3>,0.06 <0,0,1.5>, 0.02
        rotate<0,2,0>scale<10,1,1>clipped_by{plane{z,1.6}}
        translate<2.5,0,0.6>
        texture{car_body_texture}
       }

  // seat
  #local seat_shape = spline { cubic_spline
    -.25, <1.5,-0.08,0.6>
    0.00, <1.5,-0.08,0.65>
    0.25, <1.5,-0.08,0.71>
    0.50, <1.5,-0.055,0.73>
    0.75, <1.5,-0.041,0.795>
    1.00, <1.5,0,0.81>
    1.25, <1.5,0.041,0.795>
  }

  #local T_seat = texture{
    pigment{color rgb 0.6}
    finish{ambient 0.3 diffuse 0.5 phong 2 phong_size 5}
  };

  #local ni=221;
  #local i=0;
  #while(i<ni)
    #local ti=i/(ni-1);

    #local p = seat_shape(ti);
    sphere{ p, 0.0065 texture{T_seat}}
    sphere{ <1,-1,1>*p, 0.0065 texture{T_seat}}

    #if( mod(i,10)=0 )

      cylinder{p  p-z*0.4, 0.0065  texture{T_seat}}
      cylinder{<1,-1,1>*p <1,-1,1>*p-z*0.3, 0.0065  texture{T_seat}}

    #end
    #local i=i+1;
  #end

  translate <car_x,0,0>

  hollow
  }
#end
