
#include "scene.inc"
#include "car.inc"

global_settings { max_trace_level 12 }

#declare cut_time = 0.5;

#if (clock < cut_time)
  #declare tc = clock/cut_time;
  #declare f = sin(pow(tc,5)*16*pi);
  #if ( f > -0.2)
    #declare flame_flag = 1;
  #else
    #declare flame_flag = 0;
  #end

  #declare blur_factor = 1;

#else

  #declare flame_flag = 0;
  #declare blur_factor = 1 - (clock-cut_time)/(1-cut_time);

#end


#declare car_pos = <-500-800*sin(clock*pi/2.25),0,0>;
#declare cam_off = <7,-0.5+clock,1.3>;

#declare cam_pos = car_pos + cam_off;
#declare cam_rot = <-6,0,90+(180/pi)*atan2(cam_off.y,cam_pos.x-car_pos.x)-0*(10+10*pow(clock,2))>;

make_car(car_pos.x, flame_flag, blur_factor)

background{color rgb 0.5}
global_settings{ambient_light rgb 0.5}

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      
      rotate cam_rot translate cam_pos
}
light_source{<1e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 40;
make_flats( blur_factor )
