

#declare T_cloth = texture{
  pigment{bozo scale <0.003,0.01,0.003>/2
          color_map{[0 color rgb <0.2,0.3,0.4>][1 color rgb<0.6,0.7,1>]}}
  finish{ambient 0.5 diffuse 0.7}
};


#macro make_limb( p0, p1, rad, n )

  #local Rl = seed(1);

  union{
  #local ni=n;
  #local i=0;
  #while(i<ni)
    #local ti = i/(ni-1);
    #local p = p0 + ti*(p1-p0);
    #local srad = 0.75*rad + 0.25*rad*sin(ti*pi);
    #local p_jitter = 0.07*rad*<2*rand(Rl)-1,2*rand(Rl)-1,2*rand(Rl)-1>;
    sphere{<0,0,0>, srad  texture{T_cloth} translate p+p_jitter}
    #local i=i+1;
  #end
  }

#end


#macro make_arm( shoulder_pos, hand_pos, hand_rot, mirror  )

  #local elbow_pos = shoulder_pos + 0.5*(hand_pos-shoulder_pos) - <0,0,0.11>;
  #local arm = make_limb(elbow_pos, hand_pos, 0.01, 50);

  #local hand = union{

  // thumb
  #local p0 = <0.005,0,0.001>;
  #local p1 = <0,-0.008*mirror,0.006>;
  make_limb(p0,p1, 0.003, 20)

  // finger
  #local p2 = <-0.006,0,0.001>;
  #local p3 = <-0.004,-0.007*mirror,0.0>;
  make_limb(p2,p3, 0.003, 20)

  };

  union{
     object{arm}
     object{hand rotate hand_rot translate hand_pos}
  }

#end

#macro make_head()

  #local T_helmet = texture{
    pigment{rgb <0.5,0.6,1>}
    finish{ambient 0.4 diffuse 0.6 phong 2 phong_size 50}
  };

  union{
       difference{

        // shell
        union{
          sphere{<0,0,0>,1 clipped_by{plane{-z, 0}} }
          sphere{<0,0,0>,1 scale<1,1,1.8>
                 clipped_by{box{<-1.01,-1.01,-0.8><1.01,1.01,0>}} }
          texture{T_helmet}
             }
      
        // foam
        union{
          box{<-1,-1,-0.24,><-0.5,1,0.24>}
          cylinder{<-0.5,-1,0><-0.5,1,0>,0.24}
          texture{pigment{bozo scale 0.03
                          color_map{[0 color rgb 0][1 color rgb 0.6]}}
                  finish{ambient 0.5 diffuse 0.5}}
          translate<0,0,-0.03>
             }
       }

      // face
      cylinder{<0,0,-0.5><0,0,0.5>,0.65
             texture{pigment{image_map{png "eyes.png"}
                     translate<-0.5,-0.5,-0.01> scale<1,0.5,0.5>
                     rotate<90,0,-90> scale <1.1,1.2,1.1> }
                     finish{ambient rgb 0.6 diffuse 0.5}
                    }
      }

    } // end head union

#end

#macro make_figure( head_tilt, body_tilt, turn )

  union{

    // head
    #local head = make_head();
    object{head
           translate<0,0,1>
           rotate<head_tilt*20,0,0>
           translate<0,0,-1>
           scale 0.045
           translate<0,0.02*body_tilt,0>
          }

    #local left_shoulder = <0,-0.075,-0.068>;
    #local left_elbow = <-0.1,-0.05,-0.14+turn*0.05>;
    #local right_shoulder = <0,0.075,-0.068>;
    #local right_elbow = <-0.1, 0.05,-0.14-turn*0.05>;
 
    // body
    union{

      // chest
      make_limb(<0,-0.05,-0.08>, <0,0.05,-0.08>, 0.035, 100)
      make_limb(<0,-0.04,-0.095>, <0,0.04,-0.095>, 0.035, 100)
      make_limb(<0,-0.03,-0.15>, <0,0.03,-0.15>, 0.035, 100)

      // arms
      make_limb(left_shoulder, left_elbow, 0.02, 100)
      make_limb(right_shoulder, right_elbow, 0.02, 100)

      // shoulder
      make_limb(left_shoulder, right_shoulder, 0.025, 100)

      // neck
      make_limb(<0,0,-0.09>, <0,0.0,-0.03>, 0.0225, 20)

      translate<0,0.02*body_tilt,0>
    }

    // straps
    #local T_strap = texture{
      pigment{gradient y poly_wave 10 scale 0.0025
              color_map{[0 color rgb 0][1 color rgb 1]}}
      finish{ambient 0.6 diffuse 0.7 phong 0.75 phong_size 20}
    };

    #local strap = union{
      cylinder{<0,-0.008,0><0,0.008,0> 0.08 open scale<1,1,2>texture{T_strap}}
      box{<-0.03,-0.011,-0.003><0.01,0.011,0.003>translate<-0.0045,0,0.145>
          texture{pigment{rgb 1}
                  finish{ambient 0.4 diffuse 0.8 phong 2 phong_size 20}}
         }

    }
    object{strap rotate -z*body_tilt*15
           rotate<35,0,0>translate<0.028,0.011,-0.132>}
    object{strap rotate -z*body_tilt*15
           rotate<-35,0,0>translate<0.028,-0.011,-0.132>}

 } // figure union

#end
