
#include "fuel.inc"

global_settings { max_trace_level 5 }
background{color rgb 1}

#declare t0 = clock;

#macro shake( a )
  #local m = 2*pi*a;
  #local ts = (sin(3*m) + sin(7*m) + sin(11*m) + sin(13*m))/4;
  (ts/2)
#end

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio> 
      rotate z*90
      rotate<0, 4.0*abs(shake(t0)), -2*shake(t0)>
      translate<0.1,0,0>

}

light_source{<2e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e4,-1e6,1e10> color rgb 0.5 shadowless}
global_settings{ambient_light rgb 0.5}

#declare warn_time = 0.5;
#declare empty_time = 0.8;

#if( clock >= warn_time )
   #declare warn = mod(div(frame_number,5),2);
#else
   #declare warn = 0;
#end

#if( clock <= empty_time )
   #declare te = clock/empty_time;
   #declare fuel = 0.4 - te*0.4;
#else
   #declare fuel = 0;
#end

make_fuel( fuel, warn )
