
#include "scene.inc"
#include "car.inc"
#include "cockpit.inc"
#include "figure.inc"

global_settings{max_trace_level 16}
background{color rgb 0.5}
global_settings{ambient_light rgb 0.5}

#declare car_pos = 200-400*clock;
#declare cam_pos = <car_pos + 1.1, 0, 0.76>;

#macro shake( a )
  #local m = 2*pi*a;
  #local ts = (sin(3*m) + sin(7*m) + sin(11*m) + sin(13*m))/4;
  (ts/3)
#end

#declare t0 = clock - 0.5;
#declare turn = shake(-t0);
#declare head_tilt = shake(t0);
#declare body_tilt = shake(t0-0.05);

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <focal_length,0,0>
      right <0,-film_size,0>
      up <0,0,film_size*aspect_ratio>
      rotate<0, 4.0*abs(shake(t0)), -3.5*shake(t0)>
      translate cam_pos
}

light_source{ <1e4, -1e6, 1e6> color rgb 0.9}
light_source{ <-1e3, -1e4, -1e2> color rgb 0.5 shadowless}

#declare blur_factor = 100;
make_flats( blur_factor )

make_cockpit_rear_view( car_pos.x )
#declare figure = make_figure( head_tilt, body_tilt, turn  );

object{figure  translate<car_pos+1.49+0.01,0,0.75>}
