
#include "scene.inc"
#include "car.inc"

global_settings { max_trace_level 16 }

#declare car_pos = <400 - 800*pow(clock,1),0,0>;
#declare cam_off = <-1 + 3*clock, 4.5 ,1.1>;
#declare cam_pos = car_pos + cam_off;
#declare cam_rot = <-6,0,90+(180/pi)*atan2(cam_off.y,cam_pos.x-car_pos.x)+6>;

#declare flame_flag = 1;
#declare blur_factor = 1.0;

make_car(car_pos.x, flame_flag, blur_factor)

background{color rgb 0.5}
global_settings{ambient_light rgb 0.5}

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      
      rotate cam_rot translate cam_pos
}
light_source{<1e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 100;
make_flats( blur_factor )
