
#include "scene.inc"
#include "car.inc"

global_settings { max_trace_level 10 }

#declare fade_time = 0.05;
#declare drop_time = 0.15;
#declare cam_x = 7;

#if (clock <= fade_time)
  #declare fade = clock/fade_time;
  plane{x, (cam_x-0.1) pigment{color rgbt<0,0,0,fade>}finish{ambient 1} no_shadow hollow}
#end

#if (clock < drop_time)
  #declare t0 = 0;
#else
  #declare t0 = (clock-drop_time)/(1-drop_time);
#end

#declare t1 = 3*pow(t0,2)-2*pow(t0,3);
#declare cam_pos = <cam_x,0,6-5.4*t1>;
#declare cam_rot = <4-30*pow(1-0.5*(1+cos(t0*2*pi)),1.5),0,90>;

#declare flame_flag = 0;
#declare blur_factor = 0;
make_car(0, flame_flag, blur_factor)

background{color rgb 0}

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate cam_rot translate cam_pos
}
global_settings{ambient_light rgb 0.5}
light_source{<1e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 0;
make_flats( blur_factor )

