

// Sky
fog{distance 1000 color rgbt<0.8,0.9,1,0.5> }

plane{z, 80
      texture{pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                      color_map{[0 color rgb<0.6,0.7,1>][1 color rgb<1,1,1>]}
                      scale 50}
              finish{ambient 1}
             }
      hollow
      no_shadow
}

#macro make_flats( blur_factor )

  #local rocks = height_field{png "rock.png" smooth
     translate<-0.5,0,-0.5>rotate<90,0,0> scale<5000,500,60>
     texture{pigment{bozo scale 10
                     color_map{[0 color rgb <0.0,0.0,0>][1 color rgb<0.4,0.3,0.1>]}}
             finish{ambient 0.2 diffuse 0.8}}
     translate<0,0,-1>
  };
 
  #local T_flats = texture{pigment{color rgb 1}
                           finish{ambient 0.5 diffuse 0.7 phong 1 phong_size 10}
                           normal{bumps 0.5 scale 0.06*<1+blur_factor,1,1>}
  };

  #local track = polygon{5,
     <-1e10,-0.75,0><-1e10,0.75,0><1e10,0.75,0><1e10,-0.75,0><-1e10,-0.75,0>
     texture{pigment{color rgb 0.4}
             finish{ambient 0.5 diffuse 0.7 phong 1 phong_size 10}
             normal{bumps 0.5 scale 0.06*<1+blur_factor,1,1>}
            }
  };

  union{
    plane{z,0 texture{T_flats}}
    object{rocks translate<0,500,0>}
    object{rocks rotate<0,0,180>translate<0,-500,0>}
    object{track translate<0,10,0.01>}
    object{track translate<0,-10,0.01>}
  }

#end
