
#include "scene.inc"
#include "car.inc"

global_settings { max_trace_level 16 }

#declare t0 = pow(clock,2.0);

#declare car_pos = <150 - 300*pow(clock,2),0,0>;
#declare cam_off = <-15 + 15*pow(clock,1),-14+10,1.1>;
#declare cam_pos = car_pos + cam_off;
#declare cam_rot = <-2,0,90+(180/pi)*atan2(cam_off.y,cam_pos.x-car_pos.x)-15*pow(clock,2)>;

#declare flame_flag = 1;
#declare blur_factor = 1;
make_car(car_pos.x, flame_flag, blur_factor)
make_trail(car_pos.x + 5, 158,  2)

background{color rgb 0.5}
global_settings{ambient_light rgb 0.5}

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      
      rotate cam_rot translate cam_pos
}
light_source{<1e6,-1e6,1e6>color rgb <0.9,0.9,0.9>}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 10+20*pow(clock,1);
make_flats( blur_factor )
