
#include "scene.inc"
#include "car.inc"

global_settings { max_trace_level 7 }

#declare car_stop = 0.6;
#declare cam_stop = 0.8;

#if( clock <= car_stop )
  #declare t_car = clock/car_stop;
  #declare t_car = pow(sin(t_car*0.5*pi),1);
#else
  #declare t_car = 1;
#end

#if( clock <= cam_stop )
  #declare t_cam = pow(sin(0.5*pi*clock/cam_stop),2);
#else
  #declare t_cam = 1;
#end

#declare car_pos = <75 - 75*t_car,0,0>;
#declare cam_pos = <0,-20.0,10>;
#declare cam_rot = <-8-21*t_cam,0,-60 + t_cam*(60+12)>;

#declare flame_flag = 0;
#declare blur_factor = 0;
make_car(car_pos.x, flame_flag, blur_factor)

background{color rgb 0.5}
global_settings{ambient_light rgb 0.5}

#declare film_size = 0.035;
#declare focal_length = 0.045;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      
      rotate cam_rot translate cam_pos
}
light_source{<1e6,-1e6,1e6>color rgb <0.9,0.9,0.9>}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 0;
make_flats( blur_factor )


text{ttf "cyrvetic.ttf" "START" 1, 0 rotate<0,0,90> scale<7.0,5.5,0.001>
       texture{
         pigment{color rgb 0.4}
         finish{ambient 0.5 diffuse 0.7 phong 1 phong_size 10}
         normal{bumps 0.5 scale 0.06}
               }
       translate<-5,-8,0>}

polygon{5, <0,0,0><0,1,0><1,1,0><1,0,0><0,0,0>
        translate<-0.5,-0.5,0>rotate<0,0,90>scale<1.2,18,1>
        texture{
         pigment{checker color rgbt <1,1,1,1>, color rgb 0.4 scale 0.6 }
         finish{ambient 0.5 diffuse 0.7 phong 1 phong_size 10}
         normal{bumps 0.5 scale 0.06}
               }
        translate <-4,0,0.002>
         }
