// Persistence of Vision Ray Tracer Scene Description File
// File: cherepaha.pov
// Vers: 3.5
// Desc: For IRTC animation competition
// Date: 10/1/2003
// Auth: Alexander Artemenko (art@cps.tver.ru)
//

#version 3.5;

#include "colors.inc"
// several different gold colors, finishes and textures
#include "golds.inc"
// various metal colors, finishes and textures
// brass, copper, chrome, silver
#include "metals.inc"

#include "transforms.inc"

#include "pancir.pov"
#include "telo.pov"

#include "desert.pov"
#include "road.pov"
#include "track_spline.pov"
#include "kaktus.pov"

#declare isRoad = 1;
#declare isDesert = 1;
#declare isKaktus = 1;

//#include concat("Tween ", str(15*clock/2.0, 0, 0),".pov")

#macro SplineLen(Spline, BegVal, EndVal, Step, Len)
	#declare Len = 0;
	#local counter = BegVal;
	
	#while(counter < EndVal)
		#local old_counter = counter;
		#local counter = counter + Step;
		#if(counter > EndVal)
			#local counter = EndVal;
		#end

		#declare Len = Len + VDist(Spline(old_counter), Spline(counter));
	#end
#end

#declare Debug = 0;

global_settings {
  assumed_gamma 1.0
}

#declare RdmA = seed(45235);

#declare start_time = 2;
#declare stop_time = 12;
#declare go_time = stop_time-start_time;

#if(clock < start_time)
	#declare go_clock = 0;
#else      
	#declare go_clock = (clock-start_time);
#end


// ----------------------------------------

sky_sphere {
	/*
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
  */

  pigment {
    gradient y
    /*
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }*/
    pigment_map {
      [0.4 rgb <0.3,0.4,0.8>]
      [0.55 
      	bozo
      	color_map {
      		[0.6 rgb <0.0,0.1,0.8>]
      		[0.9 rgb <0.6,0.7,1.0>]
      	}
      	turbulence 0.7
      	scale <0.1, 0.1, 0.1>
      ]
      //[0.7 rgb <1.0,1.0,1.0>]
    }
    translate -0.5*y
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-10, 30, -20>
}

/*
plane {
	y, 0
	pigment { checker Black White scale 0.5}
}
*/


#if(!Debug)
	#declare tex_crome = texture {
		pigment { P_Chrome2 }
		finish { F_MetalD }
	}
	
	#declare tex_rezina = texture {
		pigment { rgb <0.01, 0.01, 0.01> }
		normal { granite .2 scale 0.1}
		finish { phong 0.6 phong_size 60 }
	}
	
	#declare tex_kuzov_top = texture {
		pigment {
			uv_mapping
			image_map {
				tiff "tex_top.tif"
			}
			//color rgb <0.55, 0.70, 0.00>
		}
	
		normal {
			uv_mapping
			bump_map {
				tiff "tex_bump.tif"
				bump_size 20
			}
		}
	
		finish {
			phong 0.9 phong_size 20 
		}
		
	}
#else
	#declare tex_crome = texture {
		pigment { P_Chrome2 }
	}
	
	#declare tex_rezina = texture {
		pigment { rgb <0.01, 0.01, 0.01> }
	}

	#declare tex_kuzov_top = texture {
		pigment { color rgb <0.85, 0.85, 0.00> }

	}
#end




#declare kuzov = object {
	pancir

	texture { tex_kuzov_top }
	
	translate y*0.5
}


#local w = 0.05;
#local r1 = 0.38;
#local r2 = 0.08;

//    ""   
#declare minus = prism {
	cubic_spline
	0.05, // sweep the following shape from here ...
	0.7, // ... up through here
	6, // the number of points making up the shape ...
	< r2, w>, // point#1 (control point... not on curve)
	< r2,  0>, // point#2  ... THIS POINT ...
	<r1,  -w>, // point#3
	<r1, w>, // point#4
	<r2, 0>, // point#5 ... MUST MATCH THIS POINT
	<r2, -w>  // point#6 (control point... not on curve)
}

#declare koleso = union {
	torus {
		0.5, 0.1
		
		texture { tex_rezina }

		scale <1, 2, 1>
	}
	
	difference {
		sphere {
			0, 0.5
			scale <1, 0.3, 1>
		}

		#if(Debug)		
			#local num = 2;
		#else
			#local num = 16;
		#end
		#local delta = 360/num;
		#local i = num;
		#local ang = 0;
		
		#while(i > 0)
			object {
				minus
				rotate y*ang
			}
			#local ang = ang + delta;
			#local i = i-1;
		#end
		
		texture { tex_crome }

		translate y*0.06
	}
	translate y*0.2
}

#local front_left = <-1.4, 0.4, 1.6>; 
#local front_right = <1.4, 0.4, 1.6>;
#local back_left = <-1.4, 0.4, -0.8>;
#local back_right = <1.4, 0.4, -0.8>;
#local depth = 0.6;

/*
#local front_left_clock = clock - 0.3;
#local front_right_clock = clock - 0.6;
#local back_left_clock = clock - 0.9;
#local back_right_clock = clock - 1.2;
*/
#local front_left_clock = clock - 0.1;
#local front_right_clock = clock - 0.2;
#local back_left_clock = clock - 0.3;
#local back_right_clock = clock - 0.4;


#if(front_left_clock <= 1)
	#if(front_left_clock > 0)
		#local front_left = front_left + x*depth*(1-front_left_clock);
	#else
		#local front_left = front_left + x*depth;
	#end
	
	#if(front_left_clock >= 0.5)
		#local front_left_clock_z = (front_left_clock-0.5)*2;
		#local front_left_z_ang = 90*front_left_clock_z;
		
		#local front_left_z_scale = 0.5+0.5*front_left_clock_z;
	#else
		#local front_left_z_ang = 0;
		#local front_left_z_scale = 0.5;
	#end
#else
	#local front_left_z_ang = 90;
	#local front_left_z_scale = 1;
#end

#if(front_right_clock <= 1)
	#if(front_right_clock > 0)
		#local front_right = front_right - x*depth*(1-front_right_clock);
	#else
		#local front_right = front_right - x*depth;
	#end
	
	#if(front_right_clock >= 0.5)
		#local front_right_clock_z = (front_right_clock-0.5)*2;
		#local front_right_z_ang = 90*front_right_clock_z;
		
		#local front_right_z_scale = 0.5+0.5*front_right_clock_z;
	#else
		#local front_right_z_ang = 0;
		#local front_right_z_scale = 0.5;
	#end
#else
	#local front_right_z_ang = 90;
	#local front_right_z_scale = 1;
#end

#if(back_left_clock <= 1)
	#if(back_left_clock > 0)
		#local back_left = back_left + x*depth*(1-back_left_clock);
	#else
		#local back_left = back_left + x*depth;
	#end
	
	#if(back_left_clock >= 0.5)
		#local back_left_clock_z = (back_left_clock-0.5)*2;
		#local back_left_z_ang = 90*back_left_clock_z;
		
		#local back_left_z_scale = 0.5+0.5*back_left_clock_z;
	#else
		#local back_left_z_ang = 0;
		#local back_left_z_scale = 0.5;
	#end
#else
	#local back_left_z_ang = 90;
	#local back_left_z_scale = 1;
#end

#if(back_right_clock <= 1)
	#if(back_right_clock > 0)
		#local back_right = back_right - x*depth*(1-back_right_clock);
	#else
		#local back_right = back_right - x*depth;
	#end
	
	#if(back_right_clock >= 0.5)
		#local back_right_clock_z = (back_right_clock-0.5)*2;
		#local back_right_z_ang = 90*back_right_clock_z;
		
		#local back_right_z_scale = 0.5+0.5*back_right_clock_z;
	#else
		#local back_right_z_ang = 0;
		#local back_right_z_scale = 0.5;
	#end
#else
	#local back_right_z_ang = 90;
	#local back_right_z_scale = 1;
#end

#declare kol_ang = 0;
SplineLen(track_spline, 0.001, 0.01*go_clock*go_clock, 0.01 /*  */, kol_ang)

#declare kol_ang = 360*kol_ang/(2*pi*0.5);

#declare kolesa = union {
	// 
	object { // 
		koleso
		scale 0.8
		scale <1, 1, back_left_z_scale>
		rotate z*back_left_z_ang	
		rotate x*kol_ang
		translate back_left 
	}
	object { // 
		koleso
		scale 0.8
		scale <1, 1, back_right_z_scale>
		rotate -z*back_right_z_ang	
		rotate x*kol_ang
		translate back_right 
	}
	
	// 
	object { // 
		koleso
		scale 0.8
		scale <1, 1, front_left_z_scale>
		rotate z*front_left_z_ang	
		rotate x*kol_ang
		translate front_left
	}
	object { // 
		koleso
		scale 0.8
		scale <1, 1, front_right_z_scale>
		rotate -z*front_right_z_ang	
		rotate x*kol_ang
		translate front_right
	}
}

// 
#declare podveska = union {
	//
	cylinder {
		front_left, front_right, 0.03
		texture { tex_crome }
		translate vnormalize(front_left-back_left)*0.1
	}
	cylinder {
		front_left, front_right, 0.03
		texture { tex_crome }
		translate -vnormalize(front_left-back_left)*0.1
	}
	
	// 
	cylinder {
		back_left, back_right, 0.03
		texture { tex_crome }
		translate vnormalize(front_left-back_left)*0.1
	}
	cylinder {
		back_left, back_right, 0.03
		texture { tex_crome }
		translate -vnormalize(front_left-back_left)*0.1
	}
}

/*
#local front_left = <-1.4, 0.4, 1.6>; 
#local front_right = <1.4, 0.4, 1.6>;
#local back_left = <-1.4, 0.4, -0.8>;
#local back_right = <1.4, 0.4, -0.8>;
*/

// 
#local rama_front_left = (front_left-vnormalize(front_left-front_right)*0.75 + vnormalize(front_left-back_left)*0.25);
#local rama_back_right =(back_right+vnormalize(front_left-front_right)*0.75 - vnormalize(front_left-back_left)*0.25) + y*0.05; 

#declare rama = union {
	box {
		(<-1.4, 0.4, 1.6>+<1.4, 0.4, 1.6>)/2 - vnormalize(front_left-front_right)*0.6,
		(<-1.4, 0.4, -0.8>+<1.4, 0.4, -0.8>)/2 - vnormalize(front_left-front_right)*0.3 + y*0.05
	}
	
	box {
		(<-1.4, 0.4, 1.6>+<1.4, 0.4, 1.6>)/2 + vnormalize(front_left-front_right)*0.3,
		(<-1.4, 0.4, -0.8>+<1.4, 0.4, -0.8>)/2 + vnormalize(front_left-front_right)*0.6 + y*0.05
	}

	texture { tex_crome }
}

#declare mobil = union {
	object { kuzov }
	object { rama }
	object { podveska }
	object { kolesa }
}

//////////////////////////////////////////////////////////////////////
//    
#local min_ext = min_extent(mobil);
#local max_ext = max_extent(mobil);
#local step = 0.001;
#local norm = <0, 0, 0>;

/*
#local front_left = <-1.4, 0.4, 1.6>; 
#local front_right = <1.4, 0.4, 1.6>;
#local back_left = <-1.4, 0.4, -0.8>;
#local back_right = <1.4, 0.4, -0.8>;
*/

//////////////////////////////////////////////////////////////////////
//   
#local start = <min_ext.x, min_ext.y-1, front_left.z>;
#local min_front_left = <0, 1000, 0>;

#while(start.x < 0)
	#local inter = trace (mobil, start, y, norm);

	#if(vlength(norm) != 0) // 
		#if(inter.y < min_front_left.y)
			#local min_front_left = inter;
		#end
	#end
	
	#local start = <start.x + step, start.y, start.z>;	
#end

//////////////////////////////////////////////////////////////////////
//   
#local start = <max_ext.x, min_ext.y-1, front_left.z>;
#local min_front_right = <0, 1000, 0>;

#while(start.x > 0)
	#local inter = trace (mobil, start, y, norm);

	#if(vlength(norm) != 0) // 
		#if(inter.y < min_front_right.y)
			#local min_front_right = inter;
		#end
	#end
	
	#local start = <start.x - step, start.y, start.z>;	
#end

//////////////////////////////////////////////////////////////////////
//   
#local start = <min_ext.x, min_ext.y-1, back_left.z>;
#local min_back_left = <0, 1000, 0>;

#while(start.x < 0)
	#local inter = trace (mobil, start, y, norm);

	#if(vlength(norm) != 0) // 
		#if(inter.y < min_back_left.y)
			#local min_back_left = inter;
		#end
	#end
	
	#local start = <start.x + step, start.y, start.z>;	
#end


//////////////////////////////////////////////////////////////////////
//   
#local start = <max_ext.x, min_ext.y-1, back_left.z>;
#local min_back_right = <0, 1000, 0>;

#while(start.x > 0)
	#local inter = trace (mobil, start, y, norm);

	#if(vlength(norm) != 0) // 
		#if(inter.y < min_back_right.y)
			#local min_back_right = inter;
		#end
	#end
	
	#local start = <start.x - step, start.y, start.z>;	
#end

//////////////////////////////////////////////////////////////////////

#if(Debug)
	cylinder { min_front_left,	min_front_left	+ y*2, 0.01 pigment { color Red } }
	cylinder { min_front_right,	min_front_right	+ y*2, 0.01 pigment { color Red } }
	cylinder { min_back_left,		min_back_left		+ y*2, 0.01 pigment { color Red } }
	cylinder { min_back_right,	min_back_right	+ y*2, 0.01 pigment { color Red } }
	
	sphere { min_front_left	+ y*2, 0.05 pigment { color Green } }
	sphere { min_front_right	+ y*2, 0.05 pigment { color Green } }
	sphere { min_back_left	+ y*2, 0.05 pigment { color Green } }
	sphere { min_back_right	+ y*2, 0.05 pigment { color Green } }
#end

#local max_y = max(min_front_left.y, min_front_right.y, min_back_left.y, min_back_right.y);
//#local min_y = min(min_front_left.y, min_front_right.y, min_back_left.y, min_back_right.y, min_extent(kuzov).y);
#local min_id = -1;
#local in = 5;
#local out = 0;
#local points_in = array[5];
#local points_in[0] = min_front_left;
#local points_in[1] = min_front_right;
#local points_in[2] = min_back_left;
#local points_in[3] = min_back_right;
#local points_in[4] = min_extent(kuzov);

//#local points_out = array[3];

// 
#local min_y = 1000;
#local i = 0;
#while(i < 5)
	#if(points_in[i].y < min_y)
		#if(abs(points_in[i].y - min_y) > 0.01)
			#local min_y = points_in[i].y; 
		#end
	#end
	#local i = i+1;
#end

#while(in > 0)
	#local in = in -1;

	#if(points_in[in].y = min_y)
		#local min_id = in;
		#break
	#end
#end


#declare car_pos = track_spline(clock/10);
#declare car_pos = <car_pos.x, 0, car_pos.z>;

#declare moved_mobil = union {
	object { Telo
		pigment {
		        uv_mapping 
			bozo
			color_map {
				[.45 rgb<40/256,  40/256, 0/256>]
				[.55 rgb<72/256, 57/256, 0/256>]
			}
			turbulence 0.2
			scale 0.1
		}
		normal {
			granite 0.5
			scale 0.2
		}
		finish {
			phong 0.5 phong_size 20 
		}
		translate y*0.5
	}
	object {
		mobil
	
		#fopen filehandle "min_id.txt" append
		#write(filehandle, concat("min_id=",str(min_id, 0, 2),"\n"))
		#fclose filehandle
		#warning concat("min_id=",str(min_id, 0, 2),"\n")
	}
Reorient_Trans(points_in[min_id], <points_in[min_id].x, 0, points_in[min_id].z>)
	translate <0, -points_in[min_id].y-0.15, 0>
	//translate car_pos
	#if(clock > 2)
		//Spline_Trans(track_spline, go_clock/go_time, y, 0.1, 0.5)
		Spline_Trans(track_spline, 0.01*go_clock*go_clock, y, 0.1, 0.5)		
	#else
		Spline_Trans(track_spline, 0.001, y, 0.1, 0.5)	
	#end
}

object { moved_mobil }

#declare max_mobil = max_extent(moved_mobil);
#declare min_mobil = min_extent(moved_mobil);
#declare pos_mobil = (max_mobil+min_mobil)/2;

#declare fn_Pigm=function {
    pigment {
      bozo
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  }


#if(clock < 4)//2.2)
	camera {
	  location  <-4.5, 2, 4>
	  direction 1.5*z
	  right     x*image_width/image_height
	  look_at   pos_mobil //<0.3, 0.5,  0.5>
	}
#else
/*
	#if(clock < 4)
		camera {
		  location  <-1.5, 2, -4>
		  direction 1.5*z
		  right     x*image_width/image_height
		  look_at   pos_mobil //<0.3, 0.5,  0.5>
		}
	#else
	*/
		camera {
		  location  <0.0, 0.0, 0.0>
		  direction 1.5*z
		  right     x*image_width/image_height
		  look_at   <0.0, 0.0,  2.0>
		  
		  //Spline_Trans(track_spline, go_clock/10, y, 0.1, 0.5)
		  Spline_Trans(track_spline, 0.01*go_clock*go_clock, y, 0.1, 0.5)
		  //translate <-1.5 + 0.1*rand(RdmA), 1 + 0.1*rand(RdmA), 0 + 0.1*rand(RdmA)>
		  translate <-1.5, 1 + 0.1*fn_Pigm(pos_mobil.x, pos_mobil.y, pos_mobil.z).gray, 0>
		}
	//#end
#end


#if(Debug)
	union {
		cylinder { 0, <2, 0, 0>, 0.05 pigment { rgb <1, 0, 0> } }
		cylinder { 0, <0, 2, 0>, 0.05 pigment { rgb <0, 1, 0> } }
		cylinder { 0, <0, 0, 2>, 0.05 pigment { rgb <0, 0, 1> } }
	}
#end



#declare texDesert=texture{
	pigment{
					bozo
		color_map{
			[ 0.000 rgbft<233/255,183/255,0/255,0.000,0.000>]
			[ 1.000 rgbft<255/255,255/255,0/255,0.000,0.000>]
		}
	}
	normal{
		granite
	}
	scale 0.05
}

#declare texAsfalt1 = texture {
	pigment { rgb <0.1, 0.1, 0.1> }
	normal { granite 0.5 scale 0.5}
	finish { phong 0.3 }
	scale 0.05
}

#declare texAsfalt2 = texture {
	pigment {
		gradient x
			color_map {
				[0 rgb <0.1, 0.1, 0.1>]
				[0.25 rgb <0.1, 0.1, 0.1>]
				[0.25 rgb <0.8, 0.8, 0.8>]
				[0.75 rgb <0.8, 0.8, 0.8>]
				[0.75 rgb <0.1, 0.1, 0.1>]
				[1 rgb <0.1, 0.1, 0.1>]
			}
			
			scale <6, 1, 1>
	}
	normal { granite 0.5 scale 0.5}
	finish { phong 0.3 }
	scale 0.05
}

#declare texRoad = texture {
	uv_mapping
	gradient y
	texture_map {
		[0.0 texDesert]
		[0.1 texAsfalt1]
		[0.48 texAsfalt1]
		[0.48 texAsfalt2]
		[0.52 texAsfalt2]
		[0.52 texAsfalt1]
		[0.9 texAsfalt1]
		[1 texDesert]
	}
}

#if(isDesert)
object {
	Desert
	texture { texDesert }
}
#end

#if(isRoad)
object {
	Road               
	translate -y*0.15
	texture { texRoad }
}
#end

#if(isKaktus)
object {
	kaktuses
}
#end

