#include "stdlib.h"
#include "stdio.h"

#define BUF_LEN 1024

char programm_name[1024];

typedef struct _FltVector
{
	float Values;
	int NumValues;
} FltVector;

typedef struct _SeqFile
{
	float Value;
	char Filename[1024];
} SeqFile;

SeqFile *Sequence = 0;
int SeqNum = 0;

int
ReadSeqFile(const char *file);

void
print_help();

void
print_title();

char *
strnopbrk(const char *str1, const char *str2);

int
main (int argc, char **argv)
{
	FILE *in1=0, *in2=0, *out=0;
	char in1_file[1024], in2_file[1024], out_file[1024];
	float value;
	int i;
	char buffer1[BUF_LEN], buffer2[BUF_LEN];
	char vector[BUF_LEN];
	char *number1, *number2, *str_write;
	float f_num1, f_num2;

	if(argc < 4 || argc > 5) {
		print_help();
		return(1);
	} else if(argc == 4) { // Sequence Loading and using
		ReadSeqFile(argv[1]);
		if(SeqNum == 0) {
			return(1);
		}
		value = atof(argv[2]);
		strncpy(out_file, argv[3], sizeof(out_file)-1);
		out = fopen(out_file, "wb");

		// Let's search our files in sequence
		for(i = 0; i < SeqNum; i++) {
			if(value < Sequence[i].Value)
				break;
		}
		if(i == 0) { // first file in sequence
			strncpy(in1_file, Sequence[i].Filename, sizeof(in1_file)-1);
			strncpy(in2_file, Sequence[i].Filename, sizeof(in2_file)-1);
			value = 0;
		} else if(i == SeqNum) { // Value not found
			strncpy(in1_file, Sequence[SeqNum-1].Filename, sizeof(in1_file)-1);
			strncpy(in2_file, Sequence[SeqNum-1].Filename, sizeof(in2_file)-1);
			value = 1;
		} else { // all other cases
			strncpy(in1_file, Sequence[i-1].Filename, sizeof(in1_file)-1);
			strncpy(in2_file, Sequence[i].Filename, sizeof(in2_file)-1);
			value = (value-Sequence[i-1].Value)/(Sequence[i].Value-Sequence[i-1].Value);
		}
			
	} else if(argc == 5) {

		strncpy(in1_file, argv[1], sizeof(in1_file)-1);
		strncpy(in2_file, argv[2], sizeof(in2_file)-1);
		value = atof(argv[3]);
		
		strncpy(out_file, argv[4], sizeof(out_file)-1);
		out = fopen(out_file, "wb");
	}
	
	in1 = fopen(in1_file, "rb");
	in2 = fopen(in2_file, "rb");

	printf("in1=%s\n", in1_file);
	printf("in2=%s\n", in2_file);
	printf("out=%s\n", out_file);

	if(in1 && in2 && out) {

		while(!feof(in1) && !feof(in2)) {
			fgets(buffer1, BUF_LEN-1, in1);
			fgets(buffer2, BUF_LEN-1, in2);

			number1 = str_write = buffer1;
			number2 = buffer2;

			while(1) {
				//  
				number1 = strpbrk(number1, "-.0123456789");
				number2 = strpbrk(number2, "-.0123456789");

				if(!number1 || !number2) { //    
					//   
					fwrite(str_write, buffer1+strlen(buffer1)-str_write, 1, out);
					break;
				} else {
					f_num1 = atof(number1);
					f_num2 = atof(number2);

					f_num1 = f_num1*(1-value) + f_num2*value;
					
					//   
					fwrite(str_write, number1-str_write, 1, out);
					//    
					fprintf(out, "%f", f_num1);
					//    
					number1 = strnopbrk(number1, "-.0123456789");
					number2 = strnopbrk(number2, "-.0123456789");

					str_write = number1;
					
				}
			}
		}
	} else {
		printf("File(s) can't be opened/created!\n");
	}
	
	fclose(in1);
	fclose(in2);
	fclose(out);
	return(0);
}


void
print_help()
{
	print_title();

	printf("Usage:\n%s input1.pov input2.pov value output.pov\nor\n%s sequence.seq value output.pov\n", programm_name, programm_name);
	return;
}

void
print_title()
{
	printf("PovMorpheus 0.0.1alpha by Alexander Artemenko\n");
	return;
}
char *
strnopbrk(const char *str1, const char *str2)
{
	const char *pos = str1;
	int i, j, len1, len2;
	char exit = 0, equ;

	len1 = strlen(str1);
	len2 = strlen(str2);

	for(i = 0; i < len1 && !exit; i++) {
		equ = 0;
		for(j = 0; j < len2; j++) {
			if(*pos == str2[j]) {
				equ = 1;
				break;
			}
		}
		if(!equ)
			exit = 1;
		else
			pos++;
	}
	
	if(i == len1) //      
		return(0);
	else
		return((char *)pos);
}

int
ReadSeqFile(const char *file)
{
	FILE *f;
	char str[1024];

	free(Sequence);
	Sequence = 0;
	SeqNum = 0;

	if(!file)
		return(SeqNum);

	f = fopen(file, "rt");
	if(!f) {
		printf("Error! Can't open sequence file!");
		return(SeqNum);
	}

	while(fgets(str, sizeof(str)-1, f)) {
		while(str[strlen(str)-1] == '\n')
			str[strlen(str)-1] = 0;
		SeqNum++;
		Sequence = (SeqFile *)realloc(Sequence, sizeof(SeqFile)*SeqNum);
		if(!Sequence) {
			printf("Memory allocation error!\n");
			return(SeqNum=0);
		}
		Sequence[SeqNum-1].Value = atof(strtok(str, " "));
		strncpy(Sequence[SeqNum-1].Filename, strtok(0, " "), sizeof(Sequence[0].Filename));
	}


	return(SeqNum);
}
