/*************************************************************************
        OBJECT EXPLODER INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
**************************************************************************

Created by Chris Colefax, March 1997

Updated 10 August 1998: updated for POV-Ray 3.1,
                        added explode_start, explode_life, time_scale,
                        object_orientation option, and disintegration options,
                        increased parsing speed without ground plane,
                        fixed Domain Error caused by some compilers

Updated 23 August 1998: fixed time_scale bug, updated documentation

See "Explode.htm" for more information.
NOTE: This file should not be included directly in a POV-Ray scene!

*************************************************************************/

// ROTATE VECTORS IF SKY IS NOT +Y
// *******************************
   #if (exp_sky.y = 1)
      #declare _EX_iloc = _EX_ptrans;
      #declare _EX_ivel = _EX_pvel;
   #else
      #declare _EX_iloc = vrotate(vrotate(_EX_ptrans, -y * _EX_wroty), -x * _EX_wrotx);
      #declare _EX_ivel = vrotate(vrotate(_EX_pvel,   -y * _EX_wroty), -x * _EX_wrotx);
   #end

// SHIFT IF GROUND DISTANCE IS NOT 0
// *********************************
   #if (ground_dist != 0) #declare _EX_iloc = _EX_iloc - ground_dist; #end

// CREATE PARTICLE IF ABOVE GROUND
// *******************************
   #if (_EX_iloc.y >= 0)

// CALCULATE PARTICLE POSITION
// ***************************
   #declare _EX_cclk = _EX_clock;
   #declare _EX_iclk = 0; #declare _EX_fclk = 0; #declare _EX_bounces = 0;
   #declare _EX_cloc = _EX_iloc + (_EX_ivel * _EX_cclk) + (.5 * _EX_grav * _EX_cclk * _EX_cclk);
   #while (_EX_cloc.y < 0)

// CALCULATE TIME OF INTERSECTION WITH GROUND PLANE
// ************************************************
   #if (_EX_grav.y = 0) #declare _EX_iclk = _EX_iloc.y / -_EX_ivel.y;
      #else #declare _EX_iclk = (-_EX_ivel.y - sqrt (_EX_ivel.y * _EX_ivel.y - (2 * _EX_grav.y * _EX_iloc.y))) / _EX_grav.y; #end

   #declare _EX_iloc = _EX_iloc + (_EX_ivel * _EX_iclk) + (.5 * _EX_grav * _EX_iclk * _EX_iclk);
   #declare _EX_ivel = (_EX_ivel + (_EX_grav * _EX_iclk)) * <1, -ground_reflection, 1>;
   #declare _EX_fclk = _EX_fclk + _EX_iclk;

// CHECK IF PARTICLE HAS STOPPED MOVING
// ************************************
   #if (ground_reflection = 0 | _EX_bounces >= max_bounces)
      #declare _EX_cloc = _EX_iloc * <1, 0, 1>;
      #declare _EX_cclk = 0;
   #else
      #declare _EX_cclk = _EX_cclk - _EX_iclk;
      #declare _EX_bounces = _EX_bounces + 1;
      #declare _EX_cloc = _EX_iloc + (_EX_ivel * _EX_cclk) + (.5 * _EX_grav * _EX_cclk * _EX_cclk);
   #end #end
   #declare _EX_fclk = _EX_fclk + _EX_cclk;
   #declare _EX_ploc = _EX_cloc;

// UNDO GROUND DISTANCE SHIFT AND SKY VECTOR ROTATION
// **************************************************
   #if (ground_dist != 0) #declare _EX_ploc = _EX_ploc + ground_dist; #end
   #if (exp_sky.y != 1)   #declare _EX_ploc = vrotate(vrotate(_EX_ploc, x * _EX_wrotx), y * _EX_wroty); #end

// SPIN PARTICLE
// *************
   object {_EX_particle
      #if (exp_strength != 0 & vlength(_EX_spin) != 0)
         #declare _EX_pspin = _EX_spin * vlength(_EX_pvel) / exp_strength;
         #if (exp_turb != 0) #declare _EX_pspin = _EX_pspin * (1 + ((<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_spturb * 2)); #end
         rotate _EX_pspin * _EX_fclk * 360
      #end
   translate _EX_ploc}
   #end
