// OBJECT EXPLODER: LOGO ANIMATION
// *******************************
// This animation illustrates how a backwards explode_clock can be used
// to create an anti-explosion (the particles come together to form the
// original object).

// CAMERA AND LIGHTS
   camera {location <-5, -5, -30> look_at <0, 0, 0> angle 50}
   light_source {<10, 20, -50> rgb 1}
   light_source {<-20, -10, -20> rgb 1}

// BACKGROUND
   plane {-z, 0
      pigment {rgb 0}
      normal {waves .1 scale 10 frequency 10 phase -clock}
      finish {reflection .4 phong .1 phong_size 3 ambient 1 diffuse 0}
      translate z * 20}

// EXPLOSION PARAMETERS
   #declare explode_object = union {
      box {<-3, -4, -1>, <-1, 4, 1>}
      difference {
         cylinder {-z, z, 1 scale <3.5, 2, 1> translate <-1, 0, 0>}
         cylinder {-z, z, 1 scale <2, 1.9, 1.1> translate <-1, 0, 0>}
         clipped_by {box {<-1.1, -2.1, -1.1>, <3.1, 2.1, 1.1>}}
         translate y*2}
      difference {
         cylinder {-z, z, 1 scale <4, 2, 1> translate <-1, 0, 0>}
         cylinder {-z, z, 1 scale <2.5, 1.9, 1.1> translate <-1, 0, 0>}
         clipped_by {box {<-1.1, -2.1, -1.1>, <3.1, 2.1, 1.1>}}
         translate -y*2}
      pigment {gradient y
         color_map {[0 rgb <.2, 0, .3>] [1 rgb <1, 0, .8>]}
         translate y * -.5 scale 8.5}
      normal {waves .5 scale 3 frequency 10 phase -clock * 2}
      finish {phong .3 phong_size 5}}
   #declare explode_clock = 1 - (pow (clock, .6) * 1.3);
   #declare object_centre = <0, 0, 0>;
   #declare object_size = <6, 8, 2>;
   #declare particle_res = <3, 4, 2>;
   #declare exp_turb = 1;
   #declare scale_turb = explode_clock * .5;
   #declare rotate_turb = explode_clock;
   #declare vel_turb = .1;
   #declare dir_turb = 0;

// CREATE ANTI-EXPLOSION
   object {
      #include "Explode.inc"
      rotate y * (explode_clock + .3) * 360}
