

// paint texture
#declare BTEX0 =
   texture{
      finish {
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 20}
   }



#declare SeatTexture =
texture {
    pigment { rgb 0.92 }// <.36,.16,.07>
    finish { specular .4 roughness .08 }
    normal {crackle .5 scale .5}
	scale 0.1
}


#declare BlackHole =
texture {pigment{rgb 0} finish{ambient 0 diffuse 0}}

#declare OrangeGlassTex=
material {
    texture {
        pigment { rgbf <1.0, 0.6, 0.0, 0.8> }
            finish {
                diffuse 0.1
                reflection .25
                specular 1
                roughness 0.001
            }
    }
    interior {ior 1.5}
}
#declare RedGlassTex=
material {
    texture {
        pigment { rgbf <1.0, 0.0, 0.0, 0.8> }
            finish {
                diffuse 0.1
                reflection .25
                specular 1
                roughness 0.001
            }
    }
    interior {ior 1.5}
}
#declare GlassTex =
material {
	texture {
		pigment { color rgbf <0.97, 0.99, 0.98, 0.9> }
                finish {
                        specular 1
                        roughness 0.001
                        ambient 0
                        diffuse 0
                        reflection 0.1
                }   

	}
   	interior {
     		ior 1.5
     		fade_distance 1
     		fade_power 1001
  	}
}

#declare ClearPlastic =
material {
	texture {
		pigment { color rgbt<.65,.54,.78,.9> }
		finish { specular .8 roughness .003 }
	}
}


#declare BodyTex =
texture {
    pigment { BodyColor }
      finish {
		 ambient BodyColor*0.3
         diffuse 0.7
         specular 0.70 roughness 0.006
         reflection 0.3
         metallic
      }
      normal {bumps 0.05 scale 20}
}

#declare BodyStripesTex =
texture {
    pigment {
        gradient z 
        color_map {
            [ 0.0 BodyColor ]
            [ 0.03 BodyColor ]
            [ 0.03 White ]
            [ 0.24 White ]
            [ 0.24 BodyColor ]
            [ 0.76 BodyColor ]
            [ 0.76 White ]
            [ 0.97 White ]
            [ 0.97 BodyColor ]
            [ 1.0 BodyColor]
        }
        scale 3
    }

      finish {
		 ambient BodyColor*0.3
         diffuse 0.7
         specular 0.8
         roughness 0.01
         reflection 0.3
         metallic
      }
      
      normal {bumps 0.05 scale 20}
}


#declare BodyTex2 =
texture {
    pigment { BodyColor }
    finish {
        phong 1.0
        phong_size 20
        diffuse 0.8
    }
}
   

#declare ProfilTexture =
texture {
	pigment { color rgb<.3,.3,.3> }
	normal { bumps .1 scale .03}
	finish { ambient 0.4 phong .3 phong_size 12 }
}

#declare ReifenTexture =
      texture {
        pigment { color rgb<.18,.18,.18> }//<.12,.12,.12>
        normal { bumps .1 scale .03}
        finish { ambient 0.3  phong .3 phong_size 12 }
      }
//-------------------------------------------
#declare BrickTex = 
        texture {
                pigment { brick
                        pigment { color <1.00,0.97,0.78> },
                        pigment { color <0.94,0.61,0.49>*0.8 }
                        brick_size <0.6,0.2,0.6> 
                        mortar 0.05
                }
                normal {brick                         
                        brick_size <0.6,0.2,0.6> 
                        mortar 0.05
                }
        }
#declare Ground =
texture {
        pigment {
                spotted
                color_map {
                        [ 0.000  color rgb<0.470, 0.350, 0.200> ]
                        [ 0.800  color rgb<0.470, 0.350, 0.200> ]
                        [ 1.000  color rgb<0.144, 0.298, 0.155> ]
                }
                scale     <0.005, 0.005, 0.005>
        }
        normal {
                bumps 1.0000
                turbulence 1.000
                omega 2.000
                lambda 0.500
                scale 0.01
        }
        finish {
                diffuse 0.440
                specular 0.400
                roughness 0.0100
        }

}

//-------------------------------------------


#declare PolishedChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.8
		}
	}
#declare BrightChrome =
	texture {
		pigment { color rgb <0.69, 0.61, 0.63> }
		finish {
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .002
			reflection 0.95
		}
	}
#declare OldChrom   = 
	texture {
		pigment { color rgb <0.94, 0.93, 0.85> }// <0.94, 0.93, 0.80>
		finish {
    			brilliance 3
    			diffuse 0.6
    			metallic
    			specular 0.60
    			roughness 1/60
    			reflection 0.25
		}
         	normal { wrinkles , 0.25 scale 4}
}

#declare CopperTexture = 
texture {
	pigment {color rgb <0.50, 0.25, 0.15>}
	finish {
    	brilliance 4
    	diffuse 0.5
    	metallic
    	specular 0.80
    	roughness 1/80
    	reflection 0.5
	}
}