// Persistence of Vision Ray Tracer Scene Description File
// File: dustblur.pov
// Vers: 3.5 
// Desc: motionblur on dust.pov, Part of "topspeed - no risk"
// Date: Nov 2002
// Auth: D. Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.5;

global_settings {
  assumed_gamma 2.12
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>
  look_at  <0,0,0>
  right 1*x
  up 1*y
}

// ----------------------------------------
#declare StrtCnt = 1;
#declare EndCnt  = 240;

#declare BlrClock1  = clock*2;
#declare BlrClock2  = BlrClock1-1;

#declare FileName1 = concat ("P3_",str(BlrClock1,-3,0),".bmp")
#declare FileName2 = concat ("P3_",str(BlrClock2,-3,0),".bmp")

#debug concat(FileName2,"\n")
#debug concat(FileName1,"\n")

box {
  <-0.5, -0.5, 0>, <0.5, 0.5, 0>
  texture {
  pigment { 
  average 
    pigment_map {

          [1  image_map { sys FileName1 } scale <-1,1,1> translate <-0.5,0.5,0>] 
          [1  image_map { sys FileName2 } scale <-1,1,1> translate <-0.5,0.5,0>] 

    }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
}



