// Persistence of Vision Ray Tracer Scene Description File
// File: explode.pov
// Vers: 3.5 
// Desc: Part of "topspeed - no risk"
// Date: Nov 2002
// Auth: D. Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.5;

// #declare camera_type = 5;
#declare camera_type = 6;

#declare Test       = off;
#declare Exp_Test   = off;
        
#declare show_rock  = on;
#declare show_sky   = on;
#declare show_road  = on;
#declare show_car   = on;
#declare show_expl1 = on;
#declare show_expl2 = on;
#declare show_run   = on;
#declare StartRunTime = 0.8;

#declare show_Profil = off;
#declare show_Cockpit= on;
#declare show_Driver = on;

#include "colors.inc"
#include "metals.inc"
#include "skies.inc"
#include "functions.inc"
#include "ts-textures.inc"

#default {finish {ambient 0.15}}
global_settings { max_trace_level 40 assumed_gamma 2.4 }

// ----------------------------------------

#include "ts-params.inc"
#declare KurvenRadius = 200;

// ----------------------------------------
#switch (camera_type)
    #case (5)
        #declare Exp_Nb_Blobs_1 = 4;
        #declare Exp_Nb_Blobs_2 = 3;
        #declare Exp_Roughness  = 9;
        #declare Exp_Streaks    = 5;
    #break
    #case (6)
        #declare StartRunTime = StartRunTime+0.1;
        #declare show_expl2     = off;
        #declare Exp_Nb_Blobs_1 = 4;
        #declare Exp_Nb_Blobs_2 = 3;
        #declare Exp_Roughness  = 8;
        #declare Exp_Streaks    = 0;
    #break
#end

#if (show_sky)
    #include "ts-sky.inc"
#else
    background { rgb <0.6,0.7,1.0> }
#end
#if (show_road)
    plane { y, 0 texture {Teer3 rotate x*-90 scale 2*KurvenRadius translate -z*KurvenRadius } }
#end
#if (show_rock) 
  #declare filename = "Rocks.tga"
  object {
      height_field {
          tga filename
          smooth
          water_level 0.4
          texture {TerrainTex4 scale (<1/HF_Length2,1/HF_High2,1/HF_Length2>*12)}
      }  
      translate <-0.5,0,-0.5>
      scale  <HF_Length2, HF_High2,HF_Length2>
      translate -y*Water_Level2
      rotate y*50
      translate <0*HF_Length2,0*HF_High2,0.182*HF_Length2>
  }
#end

// ----------------------------------------

#if(clock<0)
  #declare cclock = 1+clock;
  #declare FahrWinkel = -29+(cclock*29);
  #declare Fahrweg = FahrWinkel*(2*KurvenRadius*pi)/360;
  #declare CobraPosX = KurvenRadius*sin(radians(FahrWinkel));
  #declare CobraPosZ = (KurvenRadius*cos(radians(FahrWinkel)))-KurvenRadius;
  #declare CobraPos = <CobraPosX,-0.1,CobraPosZ>;
  #declare Lenk_Bewegung      =   2;
  #declare Vorderrad_Rotation =  Fahrweg/(Vorderrad_Durchmesser*pi)*360;
  #declare Hinterrad_Rotation =  Fahrweg/(Hinterrad_Durchmesser*pi)*360;

  #if (show_car)
      #include "cobra_raeder.inc"
      #include "cobra_body.inc"
      #if (show_Driver)
          #include "driver.inc"
      #end
      #declare Raeder =
      union {
          object {Vorderrad          rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2,-Rad_Abstand_vorne/2>}
          object {Vorderrad rotate y*180 rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2, Rad_Abstand_vorne/2>}    
          object {Hinterrad          rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2,-Rad_Abstand_hinten/2>}
          object {Hinterrad rotate y*180 rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2, Rad_Abstand_hinten/2>}
      }
      #declare Cobra =
      union{
          object {Raeder}
          object {cobraBody_T0}
          #if (show_Driver)
              object { Driver  scale 5.35 rotate y*90 translate<-4.3,-0.5,0.9>  translate y*Vorderrad_Durchmesser/2 }
          #end
          translate x*(Achs_Abstand/2)
          rotate y*FahrWinkel
          translate CobraPos
      }
      object {Cobra}
  #end
#end

// ----------------------------------------


  #if((clock>=0.0)&(clock<=1.0))
    #if(show_expl1)
        #declare Exp_Seed = 2472;

        #declare Exp_Method = 1;
        #declare Exp_Max_Samples = 5;
        #declare Exp_Min_Samples = 1;
        #include "explose2.inc"
        Explosion(<0,2.0,0>, 6.0, 0.0, 1.0, 15.0, 1.875, 5.625, Exp_Streaks, off)
    #end
    #if(show_expl2)
      #include "cobra_body.inc"    
      #declare ExplodeObj = 
      object {
            cobraBody_T0 
            translate y*1
            translate x*(Achs_Abstand/2)
      }
      #declare Min = min_extent ( ExplodeObj );
      #declare Max = max_extent ( ExplodeObj );

      #declare explode_start = 0.0;
      #declare explode_life = 0.8;
      #declare time_scale = 3;
      #declare explode_object = object {ExplodeObj}
      #declare object_corner1 = Min;
      #declare object_corner2 = Max;
      #declare object_hollow  = true;
      #declare particle_res = <9, 2, 4>;
      #declare particle_object = box {< -1.0, -.75, -.75> , < 1.0, .75, .75> }
      #declare exp_location = <0, 0.1, 0>;

      #declare exp_strength = 5;
      #declare exp_gravity = 0.0;
      #declare exp_spin = .5;
      #declare exp_seed = 87632;
      #declare max_bounces = 1;
      #declare exp_turb = 1;
      #declare scale_turb = 1;
      #declare rotate_turb = 1;
      #declare vel_turb = .3;
      #declare dir_turb = .1;
      #declare spin_turb = .5;
      #include "Explode.inc"
    #end
  #end

// ----------------------------------------
#if(show_run)
  #declare TimeRun  = 2-StartRunTime;
  #declare Frames   = TimeRun*120;

  #if(clock>=StartRunTime)
    #declare rclock = (clock-StartRunTime)/TimeRun;
    #declare mclock = int(rclock*Frames+0.0001)+1;
    #if (mclock>=30)
      #declare i = (int(mclock/30)*30);
        #declare mclock = mclock-i;
        #if (mclock=0) #declare mclock=30; #end
    #end
    #if (rclock<=0.2)
        #declare dclock = 1-(0.2-rclock)/0.2;
        #declare dclock = sin((dclock - .5) * pi) / 2 + .5;
        #declare dclock = 2 + 3*dclock;
    #else
        #declare dclock = 5;    
    #end
    #declare FileName = concat ("run2_",str(mclock,0,0),".inc")
    #declare KnochenMat = 
    texture {
      pigment { color rgb 1 }
        normal { wrinkles , 0.5 scale 0.1 }
        finish {
        ambient 0.15
            diffuse 0.7
        phong 0.5
        phong_size 10.0
        roughness 0.9
      }
    }
    #declare material_1 = texture { KnochenMat }
    #declare material_2 = texture { KnochenMat }
    #declare material_3 = texture { KnochenMat }
    #declare material_4 = texture { KnochenMat }
    #declare material_5 = texture { KnochenMat }
    #declare material_6 = texture { KnochenMat }
    #declare material_7 = texture { KnochenMat }
    #declare material_8 = texture { KnochenMat }
    #declare material_9 = texture { KnochenMat }
    #declare material_10 = texture { KnochenMat }
    #declare material_11 = texture { KnochenMat }
    #declare material_12 = texture { KnochenMat }
    #declare material_13 = texture { KnochenMat }
    #declare material_14 = texture { KnochenMat }
    #declare material_15 = texture { KnochenMat }
    #declare material_16 = texture { KnochenMat }
    #declare material_17 = texture { KnochenMat }
    #declare material_18 = texture { KnochenMat }
    #declare material_19 = texture { KnochenMat }
    #declare material_20 = texture { KnochenMat }
    #declare material_21 = texture { KnochenMat }

    #declare RunWinkel = rclock*15;
    #declare CamWinkel = 8+RunWinkel;

    #declare SkelPosX = KurvenRadius*sin(radians(RunWinkel));
    #declare SkelPosZ = (KurvenRadius*cos(radians(RunWinkel)))-KurvenRadius;
    #declare SkelPos  = < -SkelPosX, 0, SkelPosZ >;

    #declare CamPosX = KurvenRadius*sin(radians(CamWinkel));
    #declare CamPosZ = (KurvenRadius*cos(radians(CamWinkel)))-KurvenRadius;
    #declare CamPos  = < -CamPosX, 0, CamPosZ >;

    #declare Skeleton = union {#include FileName  scale 5.35 rotate y*-90}

    object { Skeleton rotate y*RunWinkel translate SkelPos }
  #end
#end
// ----------------------------------------

#switch (camera_type)
#case (1)
    #declare camera_location        = <-1, 300 , 0>; 
    #declare camera_direction       = <0, 0, 1.4>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = <0,0,0>;
    #break
#case (5)
    #declare camera_location        = <-100, 4.5, -38>; 
    #declare camera_direction       = <0, 0, 1.6>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = <0,1.0,22.5>;
    #break    
#case (6)
    #declare camera_location        = CamPos+<0,2.25,-6>; 
    #declare camera_direction       = <0, 0, dclock>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = SkelPos+<0,1.6,0>;
    #break
#end

camera {
    location        camera_location 
    direction       camera_direction
    sky             camera_sky  
    right           camera_right  
    look_at         camera_look_at
}

// ----------------------------------------

light_source {
        < 0.4, 0.6, -0.83>*150000
        SunCol2*1.5
        media_attenuation off
}
light_source {
        camera_location
        SunCol2*0.3
        shadowless
        media_attenuation off
}

// ----------------------------------------