// Persistence of Vision Ray Tracer Scene Description File
// File: palm.pov
// Vers: 3.5 
// Desc: Part of "topspeed - no risk"
// Date: Nov 2002
// Auth: D. Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.5;

#include "colors.inc"
#include "skies.inc"
#include "functions.inc"
#include "ts-textures.inc"

global_settings {
  max_trace_level 120
  assumed_gamma 2.4
}
#default {finish {ambient 0.3}}

#declare show_sky     = on;
#declare show_trees   = on;
#declare show_lnsefct = on;

//-----------------------------------------

#declare KurvRad  = 400;
#declare KurvAng  =  60;
#declare PalmAbst =  36;


#declare KurvRadI = KurvRad - 0.5*PalmAbst;
#declare KurvRadA = KurvRad + 0.5*PalmAbst;

#declare AngleI = 360*PalmAbst/(2*KurvRadI*pi);
#declare AngleA = 360*PalmAbst/(2*KurvRadA*pi);

//-----------------------------------------

#declare AngCam1  = -4 + clock*(KurvAng-10);
#declare AngCam2  =  1 + clock*(KurvAng-10);

#local XC1 = KurvRad * sin(radians(AngCam1));
#local ZC1 = KurvRad - (KurvRad * cos(radians(AngCam1)));

#local XC2 = KurvRad * sin(radians(AngCam2));
#local ZC2 = KurvRad - (KurvRad * cos(radians(AngCam2)));

#declare camera_location  = <XC1,  1, ZC1>;
#declare camera_look_at   = <XC2, 30, ZC2>;
#declare camera_direction = <0, 0, 1.2>;
#declare camera_right     = <image_width/image_height,0,0>;
#declare camera_sky       = <0, 1, 0>;

camera {
  location  camera_location 
  direction camera_direction
  sky       camera_sky
  right     camera_right 
  look_at   camera_look_at
}

//-----------------------------------------

#declare light_location = < -0.65, 0.2, -1>*150000;

light_source { light_location SunCol2*1.5 }
light_source { camera_location SunCol2*0.4 shadowless }

// ----------------------------------------

plane { y, 0 texture {TerrainTex2} }

#if (show_sky)
    #include "ts-sky.inc"
#else
    background { rgb <0.6,0.7,1.0> }
#end

#if (show_trees)
  #include "mypalm.inc"
  #include "TOMTREE.inc"

  #declare Seed1 = seed(4938);
  #declare Seed2 = seed(9283);

  #declare AngCnt = 2;
  #while (AngCnt<KurvAng)
    #local XI = KurvRadI * sin(radians(AngCnt));
    #local ZI = KurvRadI - (KurvRadI * cos(radians(AngCnt))) + 0.5*PalmAbst;
    object{ TREE scale 10*(3.5+rand(Seed1)) rotate x*4*rand(Seed1) rotate y*360*rand(Seed1) translate <XI,0,ZI>}
    #declare AngCnt = AngCnt+AngleI;
  #end
  #declare AngCnt = 0;

  #while (AngCnt<KurvAng)
    #local XA = KurvRadA * sin(radians(AngCnt));
    #local ZA = KurvRadA - (KurvRadA * cos(radians(AngCnt))) - 0.5*PalmAbst;
    object{ TREE scale 10*(3.5+rand(Seed2)) rotate x*4*rand(Seed2) rotate y*360*rand(Seed2) translate <XA,0,ZA>}
    #declare AngCnt = AngCnt+AngleA;
  #end

#end


#if (show_lnsefct)

    #declare effect_location = < 0.3, 0.47, -0.29>*10000;

    #declare effect_type = "Sun"
    #declare options_only = true;
    #include "LENS.INC"

    #declare effect_scale = <1,1,1>*0.7;
    #declare effect_always_on_top = false;
    #declare rays_flicker = true;
    #declare effect_colour = <1.3, 1, 1>;
    #declare source_colour = <1.3, 1.3, .7>;
    #declare effect_brightness = 2;

    #include "LNSEFCTS.INC"
   
    #declare effect_always_on_top = true;
    #declare glow_type = 0;   
    #declare rays_type = 0;
    #declare streak_type = 0;
    #declare spots_type = 6;
    #declare spots_colour = <1.3, .9, .3>;
    #declare spots_frequency = 1.4;
    #declare effect_brightness = 2;
    #declare Lnsefcts_Camera = off;

    #include "LNSEFCTS.INC"

#end
