// Persistence of Vision Ray Tracer Scene Description File
// File: run.pov
// Vers: 3.0
// Desc: Intro of "topspeed - no risk"
// Date: Nov 2002
// Auth: Dirk Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.0;

global_settings {
  assumed_gamma 1.6
  max_trace_level 24
}

// ----------------------------------------

camera {
  location  <0.6, 0.1, 2>
  direction 2.4*z
  right     x*4/3
  look_at   <0.0, 0.3,  0.3>
}

#if (clock >= 180)
  #declare lclock = 1-(clock-180)/30;
  #declare lclock = sin((lclock - .5) * pi) / 2 + .5;
#else
  #declare lclock = 1;
#end

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb 0.6*lclock  // light's color
  translate <-30, 30, 30>*2
}

light_source {
  0*x                     // light's position (translated below)
  color rgb <1,0.5,0>*lclock       // light's color
  spotlight               // this kind of light source
  translate <40, 80, 40>*2 // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 2.5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4               // intensity falloff radius (outer, in degrees)
}
light_source {
  0*x                     // light's position (translated below)
  color rgb <0,0,1>*lclock       // light's color
  spotlight               // this kind of light source
  translate <0, 80, 40>*2 // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 2.5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4               // intensity falloff radius (outer, in degrees)
}
// ----------------------------------------

plane {
  y, 0
  pigment { color rgb 0 }
  finish {specular 1 roughness 0.0001 reflection 0.13}
}
// ----------------------------------------

#declare Bell =
texture {
  pigment { rgb <0.0977, 0.0977,0.4375> }
  normal { wrinkles , 0.25 }
  finish {
      ambient 0.3*lclock
        diffuse 0.7
        phong 0.5
        phong_size 10.0
  }
}

#declare OldChrom   = 
texture {
      pigment { color rgb <0.94, 0.93, 0.85>  }
      finish {
          brilliance 3
          diffuse 0.6
          metallic
          specular 0.60
          roughness 1/60
          reflection 0.25
      }
          normal { wrinkles , 0.25 scale 4}
}
    
#declare KnochenMat =
texture {
  pigment { color rgb <0.992157, 0.835294, 0.615686> }
    normal { wrinkles , 0.5 scale 0.1 }
    finish {
    ambient 0.15*lclock
        diffuse 0.7
    phong 0.5
    phong_size 10.0
    roughness 0.9
  }
}

#declare material_1 = texture { KnochenMat }
#declare material_2 = texture { KnochenMat }
#declare material_3 = texture { KnochenMat }
#declare material_4 = texture { KnochenMat }
#declare material_5 = texture { KnochenMat }
#declare material_6 = texture { KnochenMat }
#declare material_7 = texture { KnochenMat }
#declare material_8 = texture { KnochenMat }
#declare material_9 = texture { KnochenMat }
#declare material_10 = texture { KnochenMat }
#declare material_11 = texture { KnochenMat }
#declare material_12 = texture { KnochenMat }
#declare material_13 = texture { KnochenMat }
#declare material_14 = texture { KnochenMat }
#declare material_15 = texture { KnochenMat }
#declare material_16 = texture { KnochenMat }
#declare material_17 = texture { KnochenMat }
#declare material_18 = texture { KnochenMat }
#declare material_19 = texture { KnochenMat }
#declare material_20 = texture { KnochenMat }
#declare material_21 = texture { KnochenMat }


#declare mclock = clock;

#if (mclock>=30)
  #declare i = (int(mclock/30)*30);
    #declare mclock = mclock-i;
    #if (mclock=0) #declare mclock=30; #end
#end

#declare FileName = concat ("run2_",str(mclock,0,0),".inc")

#include FileName

fog
{
  fog_type   2
  distance   9
  color      0
  fog_offset 0.0
  fog_alt    1.0
  turbulence 0.8
}

sphere{
  <-0,0,0>,1
  pigment { rgbf<1,1,1,1> }
  finish { ambient 0 diffuse 0 }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.2
      colour_map {
          [ 0 color rgbt <1, 0, 0,   1> ]
          [ 1 color rgbt <1, 1, 0, -10> ]
      }
      samples 12
    translate -z*(-1.5+0.018*clock)
    }
    scale <36.0,6.0,36.0>
  hollow
}


#declare tclock = clock/180;

#if (tclock >= 0)
  #include "topspeed.INC"
  union{
    object {Letter_0 texture { Bell } }
    object {Letter_1 texture { Bell } }
    object {Letter_2 texture { Bell } }
    object {Letter_4 texture { Bell } }
    object {Letter_5 texture { Bell } }
    object {Letter_6 texture { Bell } }
    object {Letter_7 texture { Bell } }
    object {Letter_8 texture { Bell } }
    translate -x*2.627
    scale 0.15
      rotate y*180
      translate <0.0,0.3,1.6>-<0,0,4>*tclock*2.5
  }
#end
#if (tclock >= 0.2 )
  #include "norisk.INC"
  union{
    object {Letter_0 texture { Bell } }
    object {Letter_1 texture { Bell } }
    object {Letter_3 texture { Bell } }
    object {Letter_4 texture { Bell } }
    object {Letter_5 texture { Bell } }
    object {Letter_6 texture { Bell } }
    translate -x*1.861
    scale 0.15
      rotate y*180
      translate <0.0,0.3,1.6>-<0,0,4>*(tclock-0.2)*2.5
  }
#end

#if (tclock >= 0.4)
  #include "by.INC"
  union{
    object {Letter_0 texture { Bell } }
    object {Letter_1 texture { Bell } }
    translate -x*0.644
    scale 0.15
      rotate y*180
      translate <0.0,0.3,1.6>-<0,0,4>*(tclock-0.4)*2.5
  }
#end

#if (tclock >= 0.6)
  #include "DiDi.INC"
  union{
    object {Letter_0 texture { Bell } }
    object {Letter_1 texture { Bell } }
    object {Letter_3 texture { Bell } }
    object {Letter_4 texture { Bell } }
    object {Letter_5 texture { Bell } }
    object {Letter_6 texture { Bell } }
    object {Letter_7 texture { Bell } }
    object {Letter_8 texture { Bell } }
    object {Letter_9 texture { Bell } }
    object {Letter_10 texture { Bell } }
    translate -x*3.263
    scale 0.15
      rotate y*180
      translate <0.0,0.3,1.6>-<0,0,4>*(tclock-0.6)*2.5
  }
#end
#if (tclock >= 0.8)
    #declare Povray_Logo =
    merge {
       sphere {2*y, 1}
       difference {
          cone {2*y, 1, -4*y, 0}
          sphere {2*y, 1.4 scale <1,1,2>}
       }
       difference {
          sphere {0, 1 scale <2.6, 2.2, 1>}
          sphere {0, 1 scale <2.3, 1.8, 2> translate <-0.35, 0, 0>}
          rotate z*30 translate 2*y
       }
       rotate <0, 0, -25>
       translate <-0.5,-0.35,0>
       scale 1/4
    }

    object {
      Povray_Logo
      texture { OldChrom }
      rotate y*180
      scale 0.25
      translate <0.0,0.3,1.6>-<0,0,4>*(tclock-0.8)*2.5
    }
#end