/****************************/
/* verif. variables */

#ifndef (Exp_Nb_Blobs_1)
	#declare Exp_Nb_Blobs = 4;
#end

#ifndef (Exp_Nb_Blobs_2)
	#declare Exp_Nb_Blobs = 3;
#end

#ifndef (Exp_Seed)
	#declare Exp_Seed = 12;
#end

#ifndef (Exp_Test)
	#declare Exp_Test = false;
#end

#ifndef (Exp_Min_Samples)
	#declare Exp_Min_Samples = 1;
#end

#ifndef (Exp_Max_Samples)
	#declare Exp_Max_Samples = 5;
#end

#ifndef (Exp_Roughness)
	#declare Exp_Roughness = 7;
#end

#ifndef (Exp_Method)
	#declare Exp_Method = 1;
#end



/****************************/
/* def. macros              */
/****************************/

/******************************************************/
/*                   ShockWave                        */
/******************************************************/
#macro ShockWave(EClock, ERand)

disc {<0,0,0>, y, 1.5
	pigment {
		onion
		pigment_map {
			[0 color rgbt <1,.5,0,1>]
			[.15*EClock+0.5 color rgbt <1,.375,0,1>]
			[.95 	bozo
					color_map {
						[0 rgbt <1,1,0,1*EClock>]
						[1 rgbt <1,.5,0,1*EClock>]
					}
					turbulence 1 scale .0675 translate <0,.75*EClock,0>
			]
			[1 color rgbt <1,.5,0,1>]
		}
		translate <0,-.25*EClock,0>
	}
	finish {
		ambient 3
		diffuse 0
	}
	no_shadow hollow
	rotate 43567*ERand
	scale 15*EClock+.1
}

#end


/******************************************************/
/*                     Streak                         */
/******************************************************/
//Streak Macro
#macro Streak(Srand, Semiss, Semiss2, Sabsorb, Staille, Sclock)

#local S1=seed(Srand);
#local S2=seed(S1*123);

#local BozoDens = density {
	bozo
	color_map {
		[0.0 rgb 0.0]
		[0.2 rgb 0.0]
		[0.3 rgb 0.5]
		[1.0 rgb 1.0]
	}
	scale .15
	warp { turbulence .1 octaves 3 lambda 5 omega .3 } 
}

object {
	sphere { 0, 1
		#if (Exp_Test)
		pigment { color rgb <1,0,0> }
		finish {ambient .5 diffuse .5}
		#else
		pigment { color rgbt<1,1,1,1> }
		hollow
		interior {
			media {
				emission Semiss*(1-Sclock)
				#if (Exp_Method > 1)
				method Exp_Method
				#end
				intervals (12-Exp_Roughness)
				samples Exp_Min_Samples, Exp_Max_Samples
				confidence .9
				variance 1/255
				density {
					spherical
					cubic_wave
					color_map {
						[ 0   rgb <0, 0, 0>     ]
						[ 0.3 rgb <0.6, 0.3, 0> ]
						[ 0.7 rgb <1, 0.5, 0>   ]
						[ 1   rgb <1.5, 1.5, 1.5> ]
					}
					scale <.3, .7, .7>
					translate -.9*x
				}
			}
			media {
				emission Semiss2*(1-Sclock)/5
				absorption Sabsorb*(1-Sclock)
				#if (Exp_Method > 1)
				method Exp_Method
				#end
				intervals (12-Exp_Roughness)
				samples Exp_Min_Samples, Exp_Max_Samples
				confidence .9
				variance 1/255
				density {
					spherical
					cubic_wave
					density_map {
						[ 0.0 rgb 0    ]
						[ 0.2 BozoDens ]
						[ 1.0 BozoDens ]
					}
				}
				scale <1.3,.8,.8>
				translate -.5*x
			}
		}
		#end
		#if (Sclock < .5)
		scale <Sclock+.0001, 1, 1>
		translate -x*Sclock
		#else
		scale <.5001, 1, 1>
		translate -x*.5
		#end
		scale Staille*<1, .1, .1>
		#if (Sclock >= .5) 
		translate -Staille*(Sclock-.5)*x
		#end
		rotate rand(S1)*32145*z
		rotate rand(S2)*98542*y
	}
}

#end


/******************************************************/
/*                Calc_Position                       */
/******************************************************/
#macro Calc_Position(time, rayon, Prand)

#local St = seed(Prand);
#local j = 0;
#declare Exp_nb_ele = 0;

	/* positions */
	#while (j<Exp_Nb_Blobs_2)
		#local i = 0;
		#local tmp = Exp_Nb_Blobs_1 * sin(pi*j/(Exp_Nb_Blobs_2-1));
		#if (tmp > 0.001)
			#while (i < floor(tmp) )
				#local ecart = vrotate(y, z*180.0*j/(Exp_Nb_Blobs_2-1));
				#local ecart = vrotate(ecart, y*360.0*i/floor(tmp));
				#local ecart = vnormalize(ecart);
				#declare A_Pos[i][j] = rayon*sqrt(time)*ecart*(.7 + .6*rand(St));
				#local i = i+1;
				#declare Exp_nb_ele = Exp_nb_ele+1;
			#end
		#else
			#local ecart = vrotate(y, z*180*j/(Exp_Nb_Blobs_2-1));
			#local ecart = vnormalize(ecart);
			#declare A_Pos[0][j] = rayon*sqrt(time)*ecart*(.7 + .6*rand(St));
			#declare Exp_nb_ele = Exp_nb_ele+1;
		#end
		#local j = j+1;
	#end

#end
/* fin calcul position et vitesse */
/*-----------------------------------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------------------------------*/
/******************************************************/
/*                   Explosion                        */
/******************************************************/
#macro Explosion(pos, rayon, clock_start, clock_end, emiss1, emiss2, absorb, NbStreaks, Shock)


#if ((clock < clock_end) & (clock >= clock_start))

	#local Stream = seed(Exp_Seed);

	#declare A_Pos = array[Exp_Nb_Blobs_1][Exp_Nb_Blobs_2]

	#if (Exp_Nb_Blobs_1 < 3 )
		#declare Exp_Nb_Blobs_1 = 3;
	#end
	#if (Exp_Nb_Blobs_2 < 3 )
		#declare Exp_Nb_Blobs_2 = 3;
	#end
	#if (Exp_Method < 1 )
		#declare Exp_Method = 1;
	#end
	#if (Exp_Method > 3 )
		#declare Exp_Method = 3;
	#end

	#if (Exp_Roughness > 11 )
		#declare Exp_Roughness = 11;
	#end

	#local temps = (clock - clock_start);
	#declare temps_fin = (clock_end - clock_start);

	#local tp = pow(temps/temps_fin, .75);
	Calc_Position(tp, rayon, rand(Stream))

	#local tp2 = pow(temps/temps_fin, 1/5);
	#local Media_1 = media {
		emission emiss1*(1-tp)/Exp_nb_ele
		#if (Exp_Method > 1)
		method Exp_Method
		#end
		intervals (12-Exp_Roughness)
		samples Exp_Min_Samples, Exp_Max_Samples
		confidence .9
		variance 1/255
		density {
			spherical
			cubic_wave
			turbulence (0.19 + 4*tp) octaves 5 lambda 4 omega 0.3
			phase .1*tp
			color_map {
				[ 0   rgb <0, 0, 0>   ]
				[ 0.6 rgb <0.6, 0.3, 0> ]
				[ 0.8 rgb <1, 0.5, 0> ]
				[ 1   rgb <1.5, 1.5, 1.5> ]
			}
		}
	}

	#local Media_2 = media {
		#if (tp < 0.5)
		emission   emiss2*pow((1-pow(2*tp-1, 2)), 3)/Exp_nb_ele
		absorption absorb*pow((1-pow(2*tp-1, 2)), 3)/Exp_nb_ele
		#else
		emission   emiss2*pow((1-pow(2*tp-1, 2)), .5)/Exp_nb_ele
		absorption absorb*pow((1-pow(2*tp-1, 2)), .5)/Exp_nb_ele
		#end
		#if (Exp_Method > 1)
		method Exp_Method
		#end
		intervals (11-Exp_Roughness)
		samples Exp_Min_Samples, Exp_Max_Samples
		confidence .9
		variance 1/255
		density {
			spherical
			cubic_wave
			turbulence (.39 + 3*tp) octaves 5 lambda 3 omega 0.2
			phase .1*tp
			color_map {
				[ 0   rgb <0, 0, 0> ]
				[ 0.3 rgb <0, 0, 0> ]
				[ 0.7   rgb <1.5, 1.5, 1.5> ]
				[ 0.8   rgb <1.5, 1.5, 1.5> ]
				[ 1   rgb <0, 0, 0> ]
			}
		}
	}

	union {
		#local j = 0;

		#while (j<Exp_Nb_Blobs_2)
			#local i = 0;
			#local tmp = Exp_Nb_Blobs_1 * sin(pi*j/(Exp_Nb_Blobs_2-1));
			#if (tmp > 0.001)
				#while (i < floor(tmp) )

					#local r1 = 1.25*max(rayon*.5, sqrt(tp2)*1.2*vlength(<rayon, 0, 0> - vrotate(<rayon, 0, 0>, y*180.0/(Exp_Nb_Blobs_2-1))));
					sphere { A_Pos[i][j], r1
						#if (Exp_Test)
						pigment { color rgb <1,0,0> }
						finish {ambient .5 diffuse .5}
						#else
						pigment { color rgbt<1,1,1,1> }
						hollow
						interior {
							media {	Media_1
								rotate z*tp*tp*180*(-0.5+rand(Stream))
								rotate y*360.0*i/floor(tmp)
								scale .4*r1
								translate A_Pos[i][j]
							}
							media { Media_2
								rotate z*tp*tp*180*(-0.5+rand(Stream))
								rotate y*360.0*i/floor(tmp)
								scale .4*r1
								translate A_Pos[i][j]
							}
						}
						#end
						translate pos
					}
					
					#local i = i+1;
				#end
			#else

				#local r1 = 1.25*max(rayon*.5, sqrt(tp2)*1.2*vlength(<rayon, 0, 0> - vrotate(<rayon, 0, 0>, y*180.0/(Exp_Nb_Blobs_2-1))));
				sphere { A_Pos[0][j], r1
					#if (Exp_Test)
					pigment { color rgb <1,0,0> }
					finish {ambient .5 diffuse .5}
					#else
					pigment { color rgbt<1,1,1,1> }
					hollow
					interior {
						media {	Media_1 scale .4*r1 translate A_Pos[0][j] }
						media { Media_2 scale .4*r1 translate A_Pos[0][j] }
					}
					#end
					translate pos
				}
					
			#end

			#local j = j+1;
		#end
	} /* fin union */


	#if (NbStreaks > 0)
		#local A = NbStreaks;
		#while (A > 0)
			object {
				Streak(rand(Stream), emiss1*1.5, absorb*1.5, absorb*1.5, rayon*2, tp)
				translate pos
			}
			#local A = A-1;
		#end
	#end
	
	#if ((Shock) & (tp <= 0.5))
		object {
			ShockWave(tp, rand(Stream))
			translate pos
		}
	#end


#else
	sphere { pos, 1 pigment { color rgbt <1,1,1,1> } }
#end

#end

/************************************************************************************/
