// LENS EFFECTS: SPARKLING WATER ANIMATION
// ***************************************
// This animation shows how you can use the effect_flicker,
// effect_jitter, and effect_spin options to animate lens effects.
// It also shows how the options_only variable can be used to alter
// predefined lens effects.
//
// NOTE: This scene should be rendered as a cyclic animation.

// WATER BACKGROUND
   plane {y, 0
      pigment {rgb <0, .5, .8>}
      normal {ripples 1 scale 30 frequency 15 phase -clock}
      finish {phong .7 phong_size 20}}

// LIGHTING
   light_source {<0, 300, 200> rgb 1}

// CAMERA OPTIONS
   #declare camera_location = <0, 15, -10>;
   #declare camera_look_at = <0, 0, 0>;

// EFFECT OPTIONS
   #declare effect_type = "Star"
   #declare options_only = true; #include "LENS.INC"

// THE FOLLOWING LINE REMOVES THE RAYS FROM THE LENS EFFECT
   #declare rays_type = 0;

// LENS EFFECT ANIMATION OPTIONS
   #declare effect_flicker = 1;
   #declare effect_spin = 1 / 6;
   #declare effect_jitter = 5;
   #declare effect_location = <0, 0, 0>;

// CREATE MULTIPLE LENS EFFECT
   #declare C = 0; #while (C < 10)
      #include "LNSEFCTS.INC"
   #declare C = C + 1; #end

   global_settings {max_trace_level 20}
