#version 3.1 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
global_settings
{
  assumed_gamma 1.8
}

// ----------------------------------------

#if (clock >= 800)
#if (clock < 860)
camera
{
location <-5.5,0,-4>
//  location  <0, 0, -2>//-7
//  location  <-5, -0.75, 0>//-7
//location<0,0,-1>
  direction 1.5*z
  right     4/3*x
  look_at <0.0, 0,  -2.0>
}
#end
#end

#if (clock >= 860)
#if (clock < 1501)
camera
{
location <-5.5,0,-4>
//  location  <0, 0, -2>//-7
//  location  <-5, -0.75, 0>//-7
//location<0,0,-1>
  direction 1.5*z
  right     4/3*x
  look_at <0.0, -0.2,  (1-3*(clock-800)/60)>
}
#end
#end


#if (clock >= 1501)
#if (clock < 2101)
camera
{
location <-5.5,0,-64.6> //-4>
//  location  <0, 0, -2>//-7
//  location  <-5, -0.75, 0>//-7
//location<0,0,-1>
  direction 1.5*z
  right     4/3*x
  look_at <0.0, -0.2,  (1-3*(clock-800)/60)>
}
#end
#end

#if (clock >= 2101)
#if (clock < 9000)
camera
{
location <-5.5,0,-64.6> //-4>
//  location  <0, 0, -2>//-7
//  location  <-5, -0.75, 0>//-7
//location<0,0,-1>
  direction 1.5*z
  right     4/3*x
//  look_at <0.0, -0.2,  (1-3*(clock-800)/60)>
  look_at <0.0, -0.2,  (1-3*(2100-800)/60)>
}
#end
#end



sky_sphere {S_Cloud1}
/*{
  pigment
  {
    gradient y
    color_map { [0 color blue 0.6] [1.0 color rgb .95]}
  }
}*/

light_source
{
  0*x color <1.0, 1.0, 1.0> translate <-30, 30, -30>
//  0*x color <1.0, 1.0, 1.0> translate <0, 0, -2>
}

// ----------------------------------------


#declare rock=texture{T_Stone9 scale .1}

#declare r1 = difference {
cylinder {0*y, .2*y 1.3 texture {rock}}
cylinder {-0.01*y, 1*y 1 }
}//main cylinder

#declare r1a = union{
object {r1}
torus { 1.3 , .01 translate .195*y  texture{rock} }
torus { 1 , .01 translate .195*y texture{rock} }
torus { 1.15 , .01 texture{rock}}

}//decorated main cylinder

#declare r3 = union {

torus{.075, .015 
scale <1,2,1> rotate 90*x translate -1.32*z translate y*(.097)  rotate -5*y
texture {rock} 
}//outer ring decoration

torus{.015, .005 
scale <1,5,1> rotate 90*x translate -1.32*z translate y*(.097)  rotate -5*y
texture {rock} 
}//inner ring decoration

torus{.015, .005 
scale <1,5,1> rotate 90*x translate -1.32*z translate y*(.097)  rotate 5.5*y
texture {rock} 
}//ring on rectangle

torus{.015, .005 
scale <1,5,1> rotate 90*x translate -1.32*z translate y*(.097)  rotate 13.5*y
texture {rock} //pigment{color White}
}//ring on rectangle


#declare r2 = difference { //large boxes
cylinder {0*y, .18*y 1.32 texture{rock} 
clipped_by {plane{ x,0}} 
clipped_by {plane{ -x,0 rotate 20*y}} 
}
cylinder {-0.01*y, 1*y 1 }
}//r2 difference
object {r2}

#declare r2a = difference { //small boxes
cylinder {0*y, .04*y 1.34 texture{rock} 
clipped_by {plane{ x,0}} 
clipped_by {plane{ -x,0 rotate 3*y}} 
}
cylinder {-0.01*y, 1*y 1 }
}//r2 difference
object {r2a}
object {r2a translate (.2 - .08)*y}
object {r2a rotate 8.5*y}
object {r2a rotate 8.5*y translate (.2 - .08)*y}
object {r2a rotate 17*y}
object {r2a rotate 17*y translate (.2 - .08)*y}

}//r3 union both boxes

#declare r4 = union { 
object {r1a} 
#declare i = 0;
#while (i<12)
object {r3 rotate (i*30)*y}
#declare i=i+1;
#end
}


//plane { y, -.95 pigment {color rgb <0.3,0.7,0.1>}}

height_field {tga "../hills1.tga" smooth
	pigment { color rgb <.3,.7,.1>} 
	translate <-.5,0,-.5> scale <200,10,200>
translate -.95*y }


/*plane { y, -10 pigment {color rgb <0.3,1,0.1>} normal {dents -.5
          turbulence 100 octaves 2 omega 2 lambda 1
            frequency 500  }normal { dents -2 scale <20,10,10>} }
*/


#if (clock >= 860)
#if (clock < 2101)
sphere {0*x, .75 //8 ball
	texture {
		pigment{image_map{png "8ba2.png" //8ba.
			map_type 1}}
		}
	finish {ambient .0 reflection .2 phong 1 phong_size 9}

rotate -50*y rotate -30*z  // 30*z

//rotate -x*360*((clock-800)/60)/1.5*pi 

rotate -x*360* ((clock-800)/(60*1.5*3.14159))

translate <0,-0.2,(1-3*(clock-800)/60)>

}//8 ball
#end
#end


#if (clock >= 2101)
#if (clock < 2199) // 9000) changed

sphere {0*x, .75 //8 ball
	texture {
		pigment{image_map{png "8ba2.png" 
			map_type 1}}
		}
	finish {ambient .0 reflection .2 phong 1 phong_size 9}

rotate -50*y rotate -30*z  // 30*z

//rotate -x*360*((clock-800)/60)/1.5*pi 

// rotate -x*360* ((clock-800)/(60*1.5*3.14159))
rotate -x*360* ((2101-800)/(60*1.5*3.14159))

//translate <0,-0.2,(1-3*(clock-800)/60)>

translate <0,-0.2,(1-3*(2101-800)/60)>

}//8 ball
#end
#end


// // light

#if (clock > 2164) 
#if (clock <= 2200)
#declare fclock = (2161 - 2100) ;
#declare fclock1 = (2161 - 2115) ;
#declare fclock2 = (2161 - 2130) ;
#declare fclock3 = (2161 - 2145) ;
#declare tclock = (clock - 2165) ;

object {r4 translate -2.75*(15/15)*y translate 2*y  translate 0*y translate -64*z }
object {r4 translate -2.75*(15/15)*y  translate 2*y  translate .333*y translate -64*z }
object {r4 translate -2.75*(15/15)*y  translate 2*y  translate .666*y translate -64*z }
object {r4 translate -2.75*(15/15)*y translate 2*y translate 1*y translate -64*z }

#declare lightring = union {
cylinder { 0*y, .2*y 1
	texture {pigment {color rgbt<1,1,1,1>}}
	interior{ior 1.5}//.9
	finish{phong 5 phong_size 7}
	translate -64*z
}

light_source { 0*x color White translate -64*z translate -.9*x 
fade_distance 5 fade_power 1}
light_source { 0*x color White translate -64*z translate .9*x
fade_distance 5 fade_power 1}

light_source { 0*x color White translate -64*z 
translate -.9*x*sin(45) translate .9*z*cos(45)
fade_distance 5 fade_power 1}
light_source { 0*x color White translate -64*z translate .9*x
translate -.9*x*sin(45) translate -.9*z*cos(45)
fade_distance 5 fade_power 1}

light_source { 0*x color White translate -64*z 
translate .9*x*sin(45) translate .9*z*cos(45)
fade_distance 5 fade_power 1}
light_source { 0*x color White translate -64*z translate .9*x
translate .9*x*sin(45) translate -.9*z*cos(45)
fade_distance 5 fade_power 1}


light_source { 0*x color White translate -64*z translate -.9*z
fade_distance 5 fade_power 1}
light_source { 0*x color White translate -64*z translate .9*z
fade_distance 5 fade_power 1}

} // end union lightring

//object {lightring translate .35*y }
//object {lightring translate -.75*y }
object {lightring translate .35*y translate -(tclock/30)*1.1*y}

#end
#end



/**/ // rings coming down
#declare fclock = (clock - 2100) ;
#declare fclock1 = (clock - 2115) ;
#declare fclock2 = (clock - 2130) ;
#declare fclock3 = (clock - 2145) ;

#if (clock > 2100)
#if (clock <= 2115)
object {r4 translate -2.75*(fclock/15)*y translate 2*y  translate 0*y translate -64*z }
#end
#end
#if (clock > 2115)
#if (clock <= 2199)// 2160)
object {r4 translate -2.75*(15/15)*y translate 2*y  translate 0*y translate -64*z }
#end
#end

#if (clock > 2115)
#if (clock <= 2130)
object {r4 translate -2.75*(fclock1/15)*y  translate 2*y  translate .333*y translate -64*z }
#end
#end
#if (clock > 2130)
#if (clock <= 2199)//2160)
object {r4 translate -2.75*(15/15)*y  translate 2*y  translate .333*y translate -64*z }
#end
#end

#if (clock > 2130)
#if (clock <= 2145)
object {r4 translate -2.75*(fclock2/15)*y translate 2*y  translate .666*y translate -64*z }
#end
#end
#if (clock > 2145)
#if (clock <= 2199)//2160)
object {r4 translate -2.75*(15/15)*y  translate 2*y  translate .666*y translate -64*z }
#end
#end

#if (clock > 2145)
#if (clock <= 2160) 
object {r4 translate -2.75*(fclock3/15)*y translate 2*y translate 1*y translate -64*z }
#end
#end
#if (clock > 2160)
#if (clock <= 2199)//2160) 
object {r4 translate -2.75*(15/15)*y translate 2*y translate 1*y translate -64*z }
#end
#end




/**/ // rings coming down

/// 2160 duped to 2164

/////////////

//object {r4 translate 2*y  translate 0*y translate -64*z } //0*y

//object {r4 translate 2*y  translate .333*y translate -64*z }

//object {r4 translate 2*y  translate .666*y translate -64*z }

//object {r4 translate 2*y   translate 1*y translate -64*z }



#if (clock >= 800)
#if (clock < 860)
sphere {0*x, .75 //8 ball
	texture {
		pigment{image_map{png "8ba2.png" 
			map_type 1}}
		}
	finish {ambient .0 reflection .3 phong 1 phong_size 9}

rotate -50*y rotate -30*z

//rotate -x*360*((clock-800)/60)/1.5*pi 

rotate -x*360* ((clock-800)/(60*1.5*3.14159))

translate <0,0,(1-3*(clock-800)/60)>

}//8 ball
#end
#end

#declare gate = union{

#if (clock>=645)
cylinder { -.1*z, .1*z, 1 
texture {  pigment {color rgb<.7,.7,1>}
finish {specular .5 ambient .4
irid{ .75 thickness 1 turbulence 5}
} 
#declare modc = mod (clock, 14400)
normal {bumps 5 scale .7 turbulence 10 translate <2*modc*360/14400,0,2*modc*360/14400>}
}
interior {ior 2.2 caustics 1}
}
#end

#declare iring = union {

#declare r1 = difference {
cylinder{-.15*z, .15*z, 1.25}
cylinder{-.2*z, .2*z, 1}
}//diff r1

#declare r2 = difference {
object {r1}
torus{1.25, 0.05 rotate 90*x translate .15*z}
}//r2

#declare r3 = difference {
object {r2}
torus{1.25, 0.05 rotate 90*x translate -.15*z}
}//diff r3
//r3
}//union iring

#declare r45 =union {
torus {1, 0.03 rotate 90*x translate -.15*z}
}//inner cutouts

#declare r6 = difference {
object{r3}
object{r45}
}
//r6

#declare rods = union {
#declare i=0;
#while (i<20)
cylinder{-2*y, 2*y, .01 rotate i*z*360/40}
#declare i=i+1;
#end
}//rods

#declare r7= difference{
object {r6}
object {rods translate -.15*z}
}

#declare alphas = 
"ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"

#declare syms = union {
#declare i=0;
#while (i<41)
text { ttf "/home/matt/fonts/klingon_.ttf" substr(alphas,i,1) 1.,0
//text { ttf "timrom.ttf" substr(alphas,i,1) 1.,0
scale .125 scale<1,1.3,1> // pigment{White} 
//rotate ((360/80)+i*360/40)*z  
translate 1.05*y 
//rotate ((360/78)+i*360/39)*z 
rotate (i*360/40)*z
rotate -(360/80)*z*.5
translate -.225*z}
#declare i=i+1;
#end
}//syms
//syms

#declare r8=difference{
object{r7}
object{syms}
}

//object {iring pigment{color <.7,.7,.7>}}
//object {r7 pigment{color <.7,.7,.7>}}

#if (clock>=400) 
#if (clock<490)  
object {r8 
texture{T_Stone9 scale .1}rotate (360/80)*z  rotate -(clock-400)*z  
} //***************
#end
#end

#if (clock>=490) 
#if (clock<505)  
object {r8 
texture{T_Stone9 scale .1}rotate (460/80)*z  rotate -(489-400)*z
} //***************
#end
#end

//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

#if (clock>504)  
object {r8 
texture{T_Stone9 scale .1}rotate (460/80)*z  rotate -(489-400)*z
} //***************
#end


/*#declare r1 = difference {
cylinder{-.15*z, .15*z, 1.25}
cylinder{-.2*z, .2*z, 1}
}//diff r1
*/

#declare oring = union {
cylinder{-.09*z, .09*z 1.4}
torus{1.4, .03 rotate 90*x translate .06*z}
torus{1.4, .03 rotate 90*x translate -.06*z}
cylinder{-.06*z, .06*z, 1.43}
}//oring

#declare o2ring = difference {
object{oring}
cylinder{ -1*z, 1*z, 1.01}
}


#declare rods2 = union {
cylinder{-1*y, 1*y, .05 translate<-1,0,-1>}
cylinder{-1*y, 1*y, .05 translate<1,0,-1>}
cylinder{-1*y, 1*y, .05 translate<-1,0,1>}
cylinder{-1*y, 1*y, .05 translate<1,0,1>}
}

#declare rbox = difference {
box { <-1,-1,-1>,<1,1,1>}
object{rods}
}

#declare chev = union{
object{rbox scale<.4,1,.1>
matrix <1,0,0,
-.5,1,0,
0,0,1,
0,0,0>
translate <.5,0.0>
}
object{rbox scale<.4,1,.1>
matrix <1,0,0,
.5,1,0,
0,0,1,
0,0,0>
translate <-.5,0.0>
}
object{rbox scale<1.45,.2,1>
translate <0,-1.2,0.9>
}
object{rbox scale<1.45,1,.2>
translate <0,0,0.9>
}
}//union chev

#declare o3ring = union {
object {o2ring}

#if (clock>=400)
#if (clock<490)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.3 ,-.2 > }
#end
#end

/*
#if (clock>=490)
#if (clock<505)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.3-(clock-486)*.2/15 ,-.2 > }
#end
#end
*/
/*
#if (clock=501)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1 ,-.2 > }
#end
*/


#if (clock>=0)
#if (clock<200)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.3,-.2 > rotate 40*z}
#end
#end

#if (clock>=290) 
#if (clock<305)  
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate<0 ,1.3 -(clock-290 )*.2/15,-.2>rotate 40*z}
#end
#end

#if (clock>=305)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate 40*z}
#end


object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate -40*z}

object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate 80*z}
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate -80*z}

object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate 115*z}
object {chev scale<1,1.3,1> rotate 180*z
scale .1 translate <0 , 1.1,-.2 > rotate -115*z}
}

object{o3ring texture{T_Stone9 scale .1}}


#if (clock>=490)
#if (clock<505)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 texture{T_Stone9 scale .1}
translate <0 , 1.3-(clock-486)*.2/15 ,-.2 > }
#end
#end

#if (clock>=505)
object {chev scale<1,1.3,1> rotate 180*z
scale .1 texture{T_Stone9 scale .1}
translate <0 , 1.1 ,-.2 > }
#end

#declare stairs = union {
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1,1,.1>*2} 
translate<-1.005,-.95,0>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.8,1,.08>*2 translate<1,1,1>} 
translate<1.005,-.95,0>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1.2,1.7,.41>*2} 
translate<-1.005,-1,0>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.7,1.1,.04>*2 translate<1,1,1>} 
translate<1.005,-1,0>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1.2,1,.21>*2} 
translate<-1.005,-1.05,0>}
box{<-1,-1,-1>,<1,1,1> scale<1.3,.1,1>
texture{T_Stone9 scale <.6,1,.06>*2 translate<1,1,1>} 
translate<1.005,-1.05,0>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1,1,.1>*2 translate<-pi,2,1>}
translate<-1.005,-1.,-.4>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.8,1,.08>*2 translate<1,2,1>} 
translate<1.005,-1.,-.4>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1,1,.1>*2 translate<-pi,2,1>}
translate<-1.005,-1.05,-.4>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.8,1,.08>*2 translate<1,2,1>} 
translate<1.005,-1.05,-.4>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1,1,.1>*2 translate<2,2,1>}
translate<-1.005,-1.05,-.8>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.8,1,.08>*2 translate<pi,2,1>} 
translate<1.005,-1.05,-.8>}

box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <1,1,.1>*2 translate<2,2,1>}
translate<-1.005,-1.11,-.8>}
box{<-1,-1,-1>,<1,1,1> scale<1,.1,1>
texture{T_Stone9 scale <.8,1,.08>*2 translate<pi,2,1>} 
translate<1.005,-1.11,-.8>}


}
object {stairs translate .1*y scale <.7,1,1>}

}//gate

object {gate rotate 0*y}

#declare shape5 =
lathe {
    cubic_spline
12,
<0,1>,
<0.756218,0.951057>,
<0.561285,0.809017>,
<0.466744,0.587785>,
<0.428582,0.309017>,
<0.5,0>,
<0.822475,-0.309017>,
<0.842273,-0.587785>,
<0.631657,-0.809017>,
<0.501455,-0.951057>,
<0.025,-1>
<0,-1.2>
}

#if (clock >=600)
#if (clock <645)
object {
  shape5


translate <0,-1,0> // <0,(tt/2.5)-20*tt, 0>
rotate 90*x
#if (clock >=600)
#if (clock <615)
//  scale <.85,.85,1> // .5 > z .2 > 2
scale< .4+(clock-600)*.45/15,.4+(clock-600)*.45/15,.2+(clock-600)*2/15>
#end
#end
#if (clock >=615)
#if (clock <645)
//  scale <.85,.85,1> // .5 > z .2 > 2
scale< .85,.85,2-(clock-615)*2/30>
#end
#end


texture {  pigment {color rgb<.7,.7,1>}
finish {specular .5 ambient .4
irid{ .75 thickness 1 turbulence 5}
} 
#declare modc1 = mod (clock, 1440)
normal {bumps 5 scale 1.4 turbulence 10 translate <2*modc1*360/1440,0,2*modc1*360/1440>}
}
interior {ior 2.2 caustics 1}
translate 0*z
rotate 0*z}

#end
#end

