/* TURBINE.INC - Programmed by Maarten Hofman */
/* 070203: Started programming */
/* 030303: Lights now depend on electricity availability */
/* 070303: Added stairs */
/* 160303: Added doorknob */
/* 190303: Centered rod looks better */

/* House next to dam */
difference {
  box {
    <812,0,795>,
    <797,waterlevel+10,765>
  }
  box {
    <811,waterlevel+2,794>,
    <798,waterlevel+9,766>
  }
  cylinder {
    <801,waterlevel+3,769>
    <801,waterlevel-5,769>,2
  }
  /* Door 1 */
  box {
    <810,waterlevel+2,790>,
    <813,waterlevel+5,791.5>
  }           
  /* Door 2 */
  box {
    <810,waterlevel-8,770>,
    <813,waterlevel-5,768.5>
  }
  box {
    <796,waterlevel+7,785>,
    <813,waterlevel+8,786>
  } 
  box {
    <796,waterlevel+7,790>,
    <813,waterlevel+8,791>
  } 
  box {
    <796,waterlevel+7,780>,
    <813,waterlevel+8,781>
  } 
  box {
    <796,waterlevel+7,775>,
    <813,waterlevel+8,776>
  } 
  box {
    <796,waterlevel+7,770>,
    <813,waterlevel+8,771>
  }
  cylinder {
    <804.5,waterlevel+8,775.5>,
    <804.5,waterlevel+9.9,775.5>,1
  } 
  pigment {
    brick pigment { DarkSlateGray } pigment { Yellow }
    scale 0.2
  }                                                 
}
/* Roof */
difference {
  box {
    <812,waterlevel+10,795>,
    <797,waterlevel+15,765>
  }
  box {
    <0,0,-10>,
    <10,10,70>
    rotate <0,0,60>
    translate <812,waterlevel+10,765>
  }   
  box {
    <0,0,-10>,
    <-10,10,70>
    rotate <0,0,-60>
    translate <797,waterlevel+10,765>
  }
  box {
    <-10,0,0>
    <25,10,-10>
    rotate <50,0,0>
    translate <797,waterlevel+10,765>
  }
  box {
    <-10,0,0>
    <25,10,10>
    rotate <-50,0,0>
    translate <797,waterlevel+10,795>
  }  
  pigment {
    brick pigment { DarkSlateGray } pigment { Red }
    scale 0.4
  }
}
        
#declare upperdoor = union {
  box {
    <0,0.1,0>,
    <0.5,3,1.5>
    texture {
      T_Wood1
    }
  }
  sphere { <-0.1,1.2,1.1>,0.1 texture { T_Chrome_3C } }
  sphere { <0.6,1.2,1.1>,0.1 texture { T_Chrome_3C } }
}

/* Plint */
box {
  <0,0,0>,
  <1,0.1,1.5>
  translate <811,waterlevel+2,790>
  texture {
    T_Stone6
  }
}
box {
  <0,0,0>,
  <1,0.1,1.5>
  translate <811,waterlevel-8,768.5>
  texture {
    T_Stone6
  }
}

object {
  upperdoor
  rotate <0,td,0>
  translate <811,waterlevel+2,790>
}

/* Lower door */
box {
  <811,waterlevel-7.9,770>,
  <811.5,waterlevel-5,768.5>
  texture {
    T_Wood1
  }
}

/* Windows */
union {
  box {
    <812.5,waterlevel+7,785>,
    <812.6,waterlevel+8,786>
  } 
  box {
    <812.5,waterlevel+7,790>,
    <812.6,waterlevel+8,791>
  } 
  box {
    <812.5,waterlevel+7,780>,
    <812.6,waterlevel+8,781>
  } 
  box {
    <812.5,waterlevel+7,775>,
    <812.6,waterlevel+8,776>
  } 
  box {
    <812.5,waterlevel+7,770>,
    <812.6,waterlevel+8,771>
  }
  
  box {
    <797.5,waterlevel+7,785>,
    <797.6,waterlevel+8,786>
  } 
  box {
    <797.5,waterlevel+7,790>,
    <797.6,waterlevel+8,791>
  } 
  box {
    <797.5,waterlevel+7,780>,
    <797.6,waterlevel+8,781>
  } 
  box {
    <797.5,waterlevel+7,775>,
    <797.6,waterlevel+8,776>
  } 
  box {
    <797.5,waterlevel+7,770>,
    <797.6,waterlevel+8,771>
  }           
  texture {
    T_Glass1
  }
  interior {
    I_Glass
  }
}

/* Light above door */
sphere {
  <812,waterlevel+6,790.75>,0.3
  pigment { White } 
  finish { ambient tl diffuse 0.8 }
}                     
light_source { <813,waterlevel+6,790.75> color <tl,tl,tl> fade_power 1 fade_distance 10 }
/* Light above door */
sphere {
  <812,waterlevel-4,769.25>,0.3
  pigment { White } 
  finish { ambient tl diffuse 0.8 }
}                     
light_source { <813,waterlevel-4,769.25> color <tl,tl,tl> fade_power 1 fade_distance 10 }

/* Lights in house */
light_source { <805,waterlevel+8,780> color <tl2,tl2,tl2> fade_power 1 fade_distance 10 }
light_source { <805,waterlevel+8,789> color <tl2,tl2,tl2> fade_power 1 fade_distance 10 }
light_source { <805,waterlevel+8,771> color <tl2,tl2,tl2> fade_power 1 fade_distance 10 }
sphere { <805,waterlevel+9,780>,0.3 pigment { White } finish { ambient 0.9 diffuse 0.8 } }
sphere { <805,waterlevel+9,789>,0.3 pigment { White } finish { ambient 0.9 diffuse 0.8 } }
sphere { <805,waterlevel+9,771>,0.3 pigment { White } finish { ambient 0.9 diffuse 0.8 } }

/* Floor in the house */
difference {
  box {
    <798,waterlevel+2,766>,
    <811,waterlevel+2.1,794>
  }
  cylinder {
    <801,waterlevel+3,769>,
    <801,waterlevel-5,769>,2
  }
  texture {
    T_Stone1
  }
}   

/* Warning around the stair well */
difference {
  cylinder {
    <801,waterlevel+2.1,769>,
    <801,waterlevel+2.11,769>,2.2
  }
  cylinder {
    <801,waterlevel+2,769>,
    <801,waterlevel+3,769>,2
  }                         
  pigment {
    quilted color_map { [0.5 YellowGreen][0.5 Black]}
    frequency 5
  }                                                  
  finish {
    ambient 0.7
    diffuse 0.5
  }
}
  
/* Stairs from the floor */
union {
  cylinder {
    <801.5,waterlevel+4,768>,
    <801.5,waterlevel-5,768>,0.1
  }
  cylinder {
    <800.5,waterlevel+4,768>,
    <800.5,waterlevel-5,768>,0.1
  }
  cylinder { <801.5,waterlevel+3.5,768>,<800.5,waterlevel+3.5,768>,0.1 }
  cylinder { <801.5,waterlevel+3.0,768>,<800.5,waterlevel+3.0,768>,0.1 }
  cylinder { <801.5,waterlevel+2.5,768>,<800.5,waterlevel+2.5,768>,0.1 }
  cylinder { <801.5,waterlevel+2.0,768>,<800.5,waterlevel+2.0,768>,0.1 }
  cylinder { <801.5,waterlevel+1.5,768>,<800.5,waterlevel+1.5,768>,0.1 }
  cylinder { <801.5,waterlevel+1.0,768>,<800.5,waterlevel+1.0,768>,0.1 }
  cylinder { <801.5,waterlevel+0.5,768>,<800.5,waterlevel+0.5,768>,0.1 }
  cylinder { <801.5,waterlevel+0.0,768>,<800.5,waterlevel+0.0,768>,0.1 }
  cylinder { <801.5,waterlevel-0.5,768>,<800.5,waterlevel-0.5,768>,0.1 }
  cylinder { <801.5,waterlevel-1.0,768>,<800.5,waterlevel-1.0,768>,0.1 }
    
  texture {
    T_Chrome_1B
  }
}
  
/* Turbine */
torus {
  3,1
  translate <804.5,waterlevel+3,775.5>
  pigment {
    bozo
    pigment_map {
      [0.8 ForestGreen]
      [1.0 Brown]
    }
  }
  finish {
    F_MetalA
  }
}

box {
  <806,waterlevel+2,772>,
  <808.5,waterlevel+3.5,773.5>
  pigment {
    bozo
    pigment_map {
      [0.8 DarkGreen]
      [1.0 Brown]
    }
  }
  finish {
    F_MetalA
  }
}

/* Wires */
union {
  cylinder {
    <806.5,waterlevel+3,772>,
    <811,waterlevel+4,767>,0.05
  }
  cylinder {
    <807,waterlevel+3,772>,
    <811,waterlevel+4,768>,0.05
  }
  cylinder {
    <807.5,waterlevel+3,772>,
    <811,waterlevel+4,769>,0.05
  }
  texture {
    T_Chrome_1A
  }
}

/* Connections */
union {
  cylinder {
    <810.9,waterlevel+4,767>,
    <812.1,waterlevel+4,767>,0.1
  }
  cylinder {
    <810.9,waterlevel+4,768>,
    <812.1,waterlevel+4,768>,0.1
  }
  cylinder {
    <810.9,waterlevel+4,769>,
    <812.1,waterlevel+4,769>,0.1
  }
  texture {
    T_Brass_1B
  }
}  
  
#declare rod = union {
  cylinder {
    <0,0,0>,
    <0,10,0>,0.5
  }
  cylinder {
    <0,5,0>,
    <0,6,0>,1
  }
  cylinder {
    <0,7,-0.6>,
    <0,7,0.6>,0.2
  }
  cylinder {
    <-0.6,7,0>,
    <0.6,7,0>,0.2
  }      
  cylinder {
    <0,2.5,0>,
    <0,3.5,0>,2.5
  }
  texture {
    T_Chrome_1B
  }
}
         
object {
  rod
  rotate <0,clock*720,0>
  translate <804.5,waterlevel,775.5>
}

/* Rod buffer */
difference {
  cylinder {
    <804.5,waterlevel+4.1,775.5>,
    <804.5,waterlevel+4.5,775.5>,1.5
  }                               
  torus {
    1.5,0.19
    translate <804.5,waterlevel+4.3,775.5>
  }  
  pigment {
    Orange
  }                       
  finish {
    F_MetalA
  }
}

union {
  cylinder {
    <804.5,waterlevel+4.3,776.7>,
    <811,waterlevel+4.3,776.7>,0.1
  }
  cylinder {
    <808,waterlevel+4.3,776.7>,
    <809,waterlevel+4.3,776.7>,0.2
  }
  cylinder {
    <804.5,waterlevel+4.3,774.3>,
    <811,waterlevel+4.3,774.3>,0.1
  }
  cylinder {
    <808,waterlevel+4.3,774.3>,
    <809,waterlevel+4.3,774.3>,0.2
  }
  texture {
    T_Brass_1B
  }
}

union {
  cylinder {
    <810.5,waterlevel+4.3,776.7>,
    <811,waterlevel+4.3,776.7>,0.4
  }
  cylinder {
    <810.5,waterlevel+4.3,774.3>,
    <811,waterlevel+4.3,774.3>,0.4
  }                          
  pigment {
    Red
  }
  finish {
    F_MetalA
  }
}
  
/* Wires to the various lamps */
union {
  cylinder { <808.5,waterlevel+2.1,773>,<811,waterlevel+2.1,773>,0.05 }
  cylinder { <811,waterlevel+2,773>,<811,waterlevel+9,773>,0.05 }
  cylinder { <811,waterlevel+9,773>,<805,waterlevel+9,773>,0.05 }
  cylinder { <805,waterlevel+9,773>,<805,waterlevel+9,771>,0.05 }
  cylinder { <805,waterlevel+9,780>,<805,waterlevel+9,790.75>,0.05 }
  cylinder { <811,waterlevel+6,773>,<811,waterlevel+6,790.75>,0.05 }
  cylinder { <811,waterlevel+6,790.75>,<811,waterlevel+9,790.75>,0.05 }
  cylinder { <811,waterlevel+9,790.75>,<805,waterlevel+9,790.75>,0.05 }
  pigment {
    Tan
  }
}
  
