// Note : CHESS2.INC was created from CHESS2.POV, included with the POV-Ray 3.5 distribution
// Please see CHESS2.POV for the original credits, I only deleted from the original, did not add

#include "shapes.inc"

#declare PawnBase =
    intersection {
       sphere { <0, 0, 0>, 2.5 }
       plane { -y, 0 }
}

#declare PieceBase =
    intersection {
       sphere { <0, 0, 0>, 3 }
       plane { -y, 0 }
}

#declare Pawn = union {
   sphere { <0, 7, 0>, 1.5 }

   sphere { <0, 0, 0>, 1
      scale <1.2, 0.3, 1.2>
      translate 5.5*y
   }

   intersection {
      plane { y, 5.5 }
      object {
         Hyperboloid_Y
         translate 5*y
         scale <0.5, 1, 0.5>
      }
      plane { -y, -2.5 }
   }

   sphere { <0, 0, 0>, 1
      scale <2, 0.5, 2>
      translate <0, 2.3, 0>
   }
   object { PawnBase }
}


#declare Rook = union {
   intersection {
      union {
         plane { +x, -0.5 }
         plane { -x, -0.5 }
         plane { y, 9 }
      }

      union {
         plane { +z, -0.5 }
         plane { -z, -0.5 }
         plane { y, 9 }
      }

      plane { y, 10 }
      object { Cylinder_Y scale <2, 1, 2> }
      object { Cylinder_Y scale <1.2, 1, 1.2> inverse }
      plane { -y, -8 }
   }

   intersection {
      plane { y, 8 }
      object { Hyperboloid_Y
         scale <1, 1.5, 1>
         translate 5.401924*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare Knight = union {
   intersection {
      object { Cylinder_Z
         scale <17.875, 17.875, 1>
         translate <-18.625, 7, 0>
         inverse
      }

      object { Cylinder_Z
         scale <17.875, 17.875, 1>
         translate <18.625, 7, 0>
         inverse
      }

      object { Cylinder_X
         scale <1, 5.1, 5.1>
         translate <0, 11.2, -5>
         inverse
      }

      union {
         plane { y, 0
            rotate 30*x
            translate 9.15*y
         }
         plane { z, 0
            rotate -20*x
            translate 10*y
         }
      }

      union {
         plane { -y, 0
            rotate 30*x
            translate 7.15*y
         }
         plane { y, 0
            rotate 60*x
            translate 7.3*y
         }
      }

      union {
         plane { y, 0
            rotate -45*z
         }
         plane { y, 0
            rotate 45*z
         }
         translate 9*y
      }

      object { Cylinder_Y scale <2, 1, 2> }
      sphere { <0, 7, 0>, 4 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate <0, 2.8, 0>
   }

   object { PieceBase }
}

#declare Bishop = union {
   sphere { <0, 10.8, 0>, 0.4 }

   intersection {
      union {
         plane { -z, -0.25 }
         plane { +z, -0.25 }
         plane { y, 0  }
         rotate 30*x
         translate 8.5*y
      }

      sphere { <0, 0, 0>, 1
         scale <1.4, 2.1, 1.4>
         translate 8.4*y
      }

      plane { -y, -7 }
   }

   sphere { <0, 0, 0>, 1
      scale <1.5, 0.4, 1.5>
      translate 7*y
   }

   intersection {
      plane { y, 7 }
      object {
         Hyperboloid_Y
         scale <0.6, 1.4, 0.6>
         translate 7*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare QueenAndKing = union {
   sphere { <0, 10.5, 0>, 1.5 }

   intersection {
      union {
         sphere { <1.75, 12, 0>, 0.9  rotate 150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 30*y }
         sphere { <1.75, 12, 0>, 0.9  }
         sphere { <1.75, 12, 0>, 0.9  rotate -30*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate  180*y }
         inverse
      }

      plane { y, 11.5 }

      object { QCone_Y
         scale <1, 3, 1>
         translate 5*y
      }

      plane { -y, -8 }
   }

   sphere { <0, 0, 0>, 1
      scale <1.8, 0.4, 1.8>
      translate 8*y
   }

   intersection {
      plane { y, 8 }
      object { Hyperboloid_Y
         scale <0.7, 1.6, 0.7>
         translate 7*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare Queen = union {
   sphere { <0, 12.3, 0>, 0.4 }
   object { QueenAndKing }
}

#declare King = union {
   intersection {
      union {
         intersection {
            plane { y, 13 }
            plane { -y, -12.5 }
         }

         intersection {
            plane { +x, 0.25 }
            plane { -x, 0.25 }
         }
      }

      plane { +z,  0.25 }
      plane { -z,  0.25 }
      plane { +x,  0.75 }
      plane { -x,  0.75 }
      plane { +y,  13.5  }
      plane { -y,  -11.5  }
   }

   object { QueenAndKing }
}

#declare Board =box {
   	-y, <64, 0, 64>
}

#declare King_Bottom = union {
   sphere { <0, 10.5, 0>, 1.5 }

   intersection {
      union {
         sphere { <1.75, 12, 0>, 0.9  rotate 150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 30*y }
         sphere { <1.75, 12, 0>, 0.9  }
         sphere { <1.75, 12, 0>, 0.9  rotate -30*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate  180*y }
         inverse
      }

      //plane { y, 11.5 }
      plane { y, 10.5 }

      object { QCone_Y
         scale <1, 3, 1>
         translate 5*y
      }

      plane { -y, -8 }
   }

   sphere { <0, 0, 0>, 1
      scale <1.8, 0.4, 1.8>
      translate 8*y
   }

   intersection {
      plane { y, 8 }
      object { Hyperboloid_Y
         scale <0.7, 1.6, 0.7>
         translate 7*y
      }
      plane { -y, -3 }
   }

   sphere { <0, 0, 0>, 1
      scale <2.5, 0.5, 2.5>
      translate 2.8*y
   }

   object { PieceBase }
}

#declare King_Top = union {
   intersection {
      union {
         sphere { <1.75, 12, 0>, 0.9  rotate 150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate 30*y }
         sphere { <1.75, 12, 0>, 0.9  }
         sphere { <1.75, 12, 0>, 0.9  rotate -30*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -60*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -90*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -120*y }
         sphere { <1.75, 12, 0>, 0.9  rotate -150*y }
         sphere { <1.75, 12, 0>, 0.9  rotate  180*y }
         inverse
      }

      plane { y, 11.5 }

      object { QCone_Y
         scale <1, 3, 1>
         translate 5*y
      }

      plane { -y, -10.5 }
   }
   intersection {
      union {
         intersection {
            plane { y, 13 }
            plane { -y, -12.5 }
         }

         intersection {
            plane { +x, 0.25 }
            plane { -x, 0.25 }
         }
      }

      plane { +z,  0.25 }
      plane { -z,  0.25 }
      plane { +x,  0.75 }
      plane { -x,  0.75 }
      plane { +y,  13.5  }
      plane { -y,  -11.5  }
      sphere { <0, 10.5, 0>, 1.5 inverse }
   }
}
