//+kf1.1 +kff45 +o9vert

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "chess2.inc"
#include "stones.inc"
#include "pgn.inc"
#include "anim2.pgn.inc"
#include "lights.inc"

#declare quick=0;
#declare frame_start=835;

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
	#declare T_Sand=texture {
		pigment { rgb 1 }
	}
	_Table()
	_Board(0)
#else
	#include "env.inc"
	#declare T_WhitePiece=texture {
		T_Chrome_5B
	}
	#declare T_BlackPiece=texture {
		T_Gold_5B
	}
	#declare T_Sand=texture {
		pigment { rgb 1 }
		normal {
			average
			normal_map {
				[2.0 bumps 3 scale 0.25]
				[1.0 agate scale 1]
			}
		}
		finish {
			diffuse 0.4
			specular 0.0
		}
	}
#end

#if (quick)
	light_source {
		<40, 80, -20>
		color rgb 1
	}
#else
	light_source {
		<40, 80, -20>
		color rgb sun_color/2//<1, 1, 1>
		spotlight
		point_at <32, 0, 32>
		radius 20
	}
	light_source {
		<10, 70, 20>
		color rgb flood1_color/2//<0.9, 0.9, 0.8>
		spotlight
		point_at <31, 0, 31>
		radius 25
	}
	light_source {
		<-20, 100, -20>
		color rgb flood2_color/2//<0.7, 0.5, 1>*0.6
		spotlight
		point_at <33, 0, 33>
		radius 22
	}
#end

object {
	Pawn
	#declare loc=S_QRP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QNP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QBP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	#declare loc=S_KP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KBP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KNP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KRP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Rook
	#declare loc=S_KR_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Rook
	#declare loc=S_QR_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_KN_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_QN_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_KB_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_QB_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	King
	#declare loc=S_K_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
//--------------------------------------------------------------------------------
object {
	Pawn
	#declare loc=S_QRP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QNP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QBP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Pawn
	#declare loc=S_KP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KBP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KNP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_KR_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_QR_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_KN_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_QN_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_KB_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_QB_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Queen
	#declare loc=S_Q_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Queen
	#declare loc=S_Q_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	texture { T_Sand }
	translate <7, 0, 6>*8
}
object {
	King
	texture { T_Sand }
	translate <7, 0, 7>*8
}

#declare S_L=spline {
	linear_spline
	0, <40, 6.5, 36>
	1.5, <56, 6.5, 56>
}
#declare S_A=spline {
	quadratic_spline
	0, (x+y+z)*60
	1/3, (x+y+z)*75
	1.5, (x+y+z)*150
}

camera {
	location S_L(max(clock,1.1))
	right x*(image_width/image_height)
	up y
	angle S_A(clock).x
	look_at <56, 6.5, 56>
}
