//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 6 lights, 3 materials and 10 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/05/2003    (05.04.2003)
//



/* // Scene Comment

This scene was created with Moray V3.3 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     1000.0
  color <0.898039,0.898039,0.898039,0.74902,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera Camera01
  location  <    -41.000,     -30.000,     -12.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38198,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.43054    // Vertical      40.823
  look_at   <      0.000,       0.000,      -7.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight005
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <500.0, 500.0, 1.0>
  rotate -90.0*x
  translate  500.0*y
}


light_source {   // Arealight Arealight004
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <500.0, 500.0, 1.0>
  rotate -90.0*x
  translate  -500.0*y
}


light_source {   // Arealight Arealight003
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <500.0, 500.0, 1.0>
  rotate -90.0*y
  translate  500.0*x
}


light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <500.0, 500.0, 1.0>
  rotate -90.0*y
  translate  -500.0*x
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <500.0, 500.0, 1.0>
  translate  500.0*z
}


light_source {   // Arealight Arealight006
  <0.0, 0.0, 0.0>
  color rgb <0.600, 0.480, 0.360>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 0
  jitter
  scale <10.0, 10.0, 1.0>
  translate  <-40.0, 30.0, 350.0>
}



//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "mountain.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

plane { // Clouds
  z,0
  material {
    CloudTexture
  }
  no_shadow
  scale <1000.0, 1000.0, 1.0>
  rotate -180.0*x
  translate  150.0*z
}












object {   // Hills
  height_field {
    gif "D:\Graphics\Moray For Windows\PovScn\Journey\hills_base.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <40.0, 30.0, 2.75>
  translate  -12.0*z
  material {
    MountainTexture
    scale <2.0, 2.0, 1.0>
    translate <-1.000000, -1.000000, 0.000000>
    // Transform to world space
  }
}


sphere { // BlueSky
  <0,0,0>,1
  material {
    BlueSkyTexture
  }
  hollow
  scale 10000.0
}




object {   // Mountain
  height_field {
    gif "D:\Graphics\Moray For Windows\PovScn\Journey\single_001.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <40.0, 30.0, 15.0>
  material {
    MountainTexture
    scale <2.0, 2.0, 1.0>
    translate <-1.000000, -1.000000, 0.000000>
    // Transform to world space
  }
}


