//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 6 lights, 13 materials and 93 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/05/2003    (05.04.2003)
//



/* // Scene Comment

This scene was created with Moray V3.3 For Windows.
Comment merged from round_figure4.mdl:
This scene was created with Moray For Windows.
Comment merged from house.mdl:
This scene was created with Moray V3.3 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <      7.500,     430.000,      75.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35039,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         33.30375    // Vertical      24.978
  look_at   <      0.000,      50.000,      60.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight006
  <0.0, 0.0, 0.0>
  color rgb <0.600, 0.480, 0.360>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <50.0, 50.0, 1.0>
  translate  <-350.0, -215.0, 500.0>
}


light_source {   // Arealight Arealight005
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale <3000.0, 3000.0, 1.0>
  rotate <-90.0, -90.0, 0.0>
  translate  3000.0*y
}


light_source {   // Arealight Arealight004
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale <3000.0, 3000.0, 1.0>
  rotate <-90.0, -90.0, 0.0>
  translate  -3000.0*y
}


light_source {   // Arealight Arealight003
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale <3000.0, 3000.0, 1.0>
  rotate -90.0*y
  translate  3000.0*x
}


light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale <3000.0, 3000.0, 1.0>
  rotate -90.0*y
  translate  -3000.0*x
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.850, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale <3000.0, 3000.0, 1.0>
  translate  3000.0*z
}



//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "summit.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

plane { // Clouds
  z,0
  material {
    CloudTexture
  }
  no_shadow
  scale <1000.0, 1000.0, 10.0>
  rotate 188.0*x
  translate  <-165.0, 350.0, 550.0>
}


sphere { // BlueSky
  <0,0,0>,1
  material {
    BlueSkyTexture
  }
  hollow
  scale 10000.0
}


object {   // SnowField
  height_field {
    png "D:\Graphics\Moray For Windows\PovScn\Journey\snow_hf.png"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <500.0, 500.0, 5.0>
  translate  2.5*z
  material {
    SnowTexture
    // Transform to world space
  }
}














#declare RightMiddleFingerTip = union {
  superellipsoid { // RightMiddleFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  translate  -1.0*x
}
#declare RightMiddleFingerDigit = union {
  superellipsoid { // RightMiddleFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightMiddleFingerTip }
  translate  -1.0*x
}
#declare RightMiddleFinger = union {
  superellipsoid { // RightMiddleFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightMiddleFingerDigit }
  material {
    SkinTexture
  }
  translate  -3.0*x
}
#declare RightIndexFingerTip = union {
  superellipsoid { // RightIndexFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  translate  -1.0*x
}
#declare RightIndexFingerDigit = union {
  superellipsoid { // RightIndexFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightIndexFingerTip }
  translate  -1.0*x
}
#declare RightIndexFinger = union {
  superellipsoid { // RightIndexFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightIndexFingerDigit }
  material {
    SkinTexture
  }
  translate  <-2.5, 0.0, 1.125>
}
#declare RightPinkyFingerTip = union {
  superellipsoid { // RightPinkyFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  translate  -1.0*x
}
#declare RightPinkyFingerDigit = union {
  superellipsoid { // RightPinkyFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightPinkyFingerTip }
  translate  -1.0*x
}
#declare RightPinkyFinger = union {
  superellipsoid { // RightPinkyFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  -0.5*x
  }
  object { RightPinkyFingerDigit }
  material {
    SkinTexture
  }
  translate  <-2.5, 0.0, -1.125>
}
#declare RightThumbTip = union {
  superellipsoid { // RightThumbEnd
    <0.75, 0.75>
    scale <0.5, 0.5, 1.125>
    translate  0.75*z
  }
  rotate -35.0*y
  translate  1.5*z
}
#declare RightThumb = union {
  superellipsoid { // RightThumbBase
    <0.75, 0.75>
    scale <0.5, 0.5, 1.125>
    translate  0.75*z
  }
  object { RightThumbTip }
  rotate -55.0*y
  translate  <-0.5, 0.0, 1.5>
}
#declare RightHand = union {
  superellipsoid { // RightPalm
    <0.75, 0.75>
    scale <2.0, 1.25, 1.75>
    translate  -1.25*x
  }
  object { RightMiddleFinger }
  object { RightIndexFinger }
  object { RightPinkyFinger }
  object { RightThumb }
  translate  -10.25*x
}
#declare RightForearm = union {
  superellipsoid { // RightLowerArm
    <0.75, 0.75>
    scale <5.75, 1.75, 1.75>
    translate  -4.5*x
  }
  object { RightHand }
  translate  -9.0*x
}
#declare RightArm = union {
  superellipsoid { // RightUpperArm
    <0.75, 0.75>
    scale <6.0, 1.75, 1.75>
    translate  -4.25*x
  }
  object { RightForearm }
  translate  <-4.5, 0.0, 16.75>
}
#declare LeftMiddleFingerTip = union {
  superellipsoid { // LeftMiddleFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  rotate -0.0*x
  translate  1.0*x
}
#declare LeftMiddleFingerDigit = union {
  superellipsoid { // LeftMiddleFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftMiddleFingerTip }
  rotate -0.0*y
  translate  1.0*x
}
#declare LeftMiddleFinger = union {
  superellipsoid { // LeftMiddleFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftMiddleFingerDigit }
  material {
    SkinTexture
  }
  rotate <-0.0, -0.0, 0.0>
  translate  3.0*x
}
#declare LeftIndexFingerTip = union {
  superellipsoid { // LeftIndexFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  rotate -0.0*x
  translate  1.0*x
}
#declare LeftIndexFingerDigit = union {
  superellipsoid { // LeftIndexFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftIndexFingerTip }
  rotate -0.0*y
  translate  1.0*x
}
#declare LeftIndexFinger = union {
  superellipsoid { // LeftIndexFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftIndexFingerDigit }
  material {
    SkinTexture
  }
  rotate -0.0*x
  translate  <2.5, 0.0, 1.125>
}
#declare LeftPinkyFingerTip = union {
  superellipsoid { // LeftPinkyFingerEnd
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  rotate -0.0*x
  translate  1.0*x
}
#declare LeftPinkyFingerDigit = union {
  superellipsoid { // LeftPinkyFingerMiddle
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftPinkyFingerTip }
  rotate -0.0*y
  translate  1.0*x
}
#declare LeftPinkyFinger = union {
  superellipsoid { // LeftPinkyFingerBase
    <0.75, 0.75>
    scale <0.875, 0.5, 0.5>
    translate  0.5*x
  }
  object { LeftPinkyFingerDigit }
  material {
    SkinTexture
  }
  rotate -0.0*x
  translate  <2.5, 0.0, -1.125>
}
#declare LeftThumbTip = union {
  superellipsoid { // LeftThumbEnd
    <0.75, 0.75>
    scale <0.5, 0.5, 1.125>
    translate  0.75*z
  }
  rotate <0.0, 35.0, -0.0>
  translate  1.5*z
}
#declare LeftThumb = union {
  superellipsoid { // LeftThumbBase
    <0.75, 0.75>
    scale <0.5, 0.5, 1.125>
    translate  0.75*z
  }
  object { LeftThumbTip }
  rotate 55.0*y
  translate  <0.5, 0.0, 1.5>
}
#declare LeftHand = union {
  superellipsoid { // LeftPalm
    <0.75, 0.75>
    scale <2.0, 1.25, 1.75>
    translate  1.25*x
  }
  object { LeftMiddleFinger }
  object { LeftIndexFinger }
  object { LeftPinkyFinger }
  object { LeftThumb }
  translate  10.25*x
}
#declare LeftForearm = union {
  superellipsoid { // LeftLowerArm
    <0.75, 0.75>
    scale <5.75, 1.75, 1.75>
    translate  4.5*x
  }
  object { LeftHand }
  translate  9.0*x
}
#declare LeftArm = union {
  superellipsoid { // LeftUpperArm
    <0.75, 0.75>
    scale <6.0, 1.75, 1.75>
    translate  4.25*x
  }
  object { LeftForearm }
  translate  <4.5, 0.0, 16.75>
}
#declare Head = union {
  superellipsoid { // Head1
    <0.75, 0.75>
    scale <3.0, 3.5, 3.75>
    translate  <0.0, -1.25, 1.75>
  }
  rotate -0.0*z
  translate  21.5*z
}
#declare UpperBody = union {
  cylinder { // Neck
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.25, 4.0>
    translate  18.0*z
  }
  superellipsoid { // Torso
    <0.75, 0.75>
    scale <5.625, 3.75, 10.25>
    translate  8.25*z
  }
  object { RightArm }
  object { LeftArm }
  object { Head }
  translate  32.0*z
}
#declare RightFoot = union {
  superellipsoid { // RightFootFlat
    <0.75, 0.625>
    scale <2.75, 5.0, 1.75>
    rotate <-0.0, 0.029321, -0.0>
    translate  -2.5*y
  }
  rotate -0.0*z
  translate  -17.0*z
}
#declare RightLowerLeg = union {
  superellipsoid { // RightCalf
    <0.75, 0.75>
    scale <2.5, 2.5, 9.125>
    translate  -7.625*z
  }
  object { RightFoot }
  rotate -0.0*z
  translate  -13.25*z
}
#declare RightLeg = union {
  superellipsoid { // RightThigh
    <0.75, 0.75>
    scale <2.5, 2.5, 8.375>
    translate  -6.375*z
  }
  object { RightLowerLeg }
  translate  <-3.0, 0.0, 32.0>
}
#declare LeftFoot = union {
  superellipsoid { // LeftFootFlat
    <0.75, 0.625>
    scale <2.75, 5.0, 1.75>
    translate  -2.5*y
  }
  rotate <0.0, -0.0, -0.0>
  translate  -17.0*z
}
#declare LeftLowerLeg = union {
  superellipsoid { // LeftCalf
    <0.75, 0.75>
    scale <2.5, 2.5, 9.125>
    translate  -7.625*z
  }
  object { LeftFoot }
  translate  -13.25*z
}
#declare LeftLeg = union {
  superellipsoid { // LeftThigh
    <0.75, 0.75>
    scale <2.5, 2.5, 8.375>
    translate  -6.375*z
  }
  object { LeftLowerLeg }
  translate  <3.0, 0.0, 32.0>
}
union { // Figure
  object { UpperBody }
  object { RightLeg }
  object { LeftLeg }
  material {
    SkinTexture
  }
  rotate -180.0*z
  translate  <0.0, 100.0, 1.0>
}


#declare RndCube001 = merge {
  sphere { <2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, 2.5000, -59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  box { <-2.5000, -2.5000, -60.0000> <2.5000, 2.5000, 60.0000> }
  box { <-2.5000, -3.0000, -59.5000> <2.5000, 3.0000, 59.5000> }
  box { <-3.0000, -2.5000, -59.5000> <3.0000, 2.5000, 59.5000> }
  translate  <-77.5, -77.5, 59.0>
}
#declare RndCube002 = merge {
  sphere { <2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, 2.5000, -59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  box { <-2.5000, -2.5000, -60.0000> <2.5000, 2.5000, 60.0000> }
  box { <-2.5000, -3.0000, -59.5000> <2.5000, 3.0000, 59.5000> }
  box { <-3.0000, -2.5000, -59.5000> <3.0000, 2.5000, 59.5000> }
  translate  <77.5, -77.5, 59.0>
}
#declare RndCube003 = merge {
  sphere { <2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, 2.5000, -59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  box { <-2.5000, -2.5000, -60.0000> <2.5000, 2.5000, 60.0000> }
  box { <-2.5000, -3.0000, -59.5000> <2.5000, 3.0000, 59.5000> }
  box { <-3.0000, -2.5000, -59.5000> <3.0000, 2.5000, 59.5000> }
  translate  <77.5, 77.5, 59.0>
}
#declare RndCube004 = merge {
  sphere { <2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, 59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, 59.5000>, 0.5000 }
  sphere { <2.5000, 2.5000, -59.5000>, 0.5000 }
  sphere { <2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, -2.5000, -59.5000>, 0.5000 }
  sphere { <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, -59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, -2.5000, -59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, -2.5000, -59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, 2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, 59.5000>, <2.5000, -2.5000, 59.5000>, 0.5000 }
  cylinder { <2.5000, 2.5000, -59.5000>, <2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, -59.5000>, <-2.5000, -2.5000, -59.5000>, 0.5000 }
  cylinder { <-2.5000, 2.5000, 59.5000>, <-2.5000, -2.5000, 59.5000>, 0.5000 }
  box { <-2.5000, -2.5000, -60.0000> <2.5000, 2.5000, 60.0000> }
  box { <-2.5000, -3.0000, -59.5000> <2.5000, 3.0000, 59.5000> }
  box { <-3.0000, -2.5000, -59.5000> <3.0000, 2.5000, 59.5000> }
  translate  <-77.5, 77.5, 59.0>
}
#declare CSG002 = union {
  object { RndCube001 }
  object { RndCube002 }
  object { RndCube003 }
  object { RndCube004 }
  material {
    StoneTexture
    // Transform to world space
    rotate 180.0*z
  }
}
#declare CSG003 = union {
  object { CSG002 }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 80.0, 60.0>
    translate  60.0*z
  }
}
#declare DoorAlcove = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <16.1, 16.1, 5.0>
    rotate 90.0*x
    translate  56.0*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <16.1, 2.5, 28.1>
    translate  <0.0, -2.5, 28.0>
  }
  translate  <35.0, -76.0, 0.0>
}
#declare StoneWork = difference {
  object { CSG003 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    scale <48.0, 81.0, 18.0>
    rotate -24.227739*y
    translate  120.0*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <48.0, 81.0, 18.0>
    rotate 24.227739*y
    translate  120.0*z
  }
  object { DoorAlcove }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <23.6, 2.5, 22.6>
    translate  <-30.0, -78.5, 50.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <79.0, 79.0, 61.0>
    translate  60.0*z
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 18.6, 22.6>
    translate  <-78.5, -35.0, 48.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 18.6, 22.6>
    translate  <-78.5, 35.0, 48.0>
  }
  material {
    WallTexture
  }
  hollow
}
#declare Roof = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    material {
      RoofTexture
    }
    scale <50.0, 84.0, 1.0>
    rotate -24.227739*y
    translate  122.0*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    material {
      RoofTexture
    }
    scale <50.0, 84.0, 1.0>
    rotate 24.227739*y
    translate  122.0*z
  }
}
#declare CSG001 = difference {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <23.5, 1.0, 22.5>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 1.1, 20.0>
  }
  material {
    T_Wood5
    scale 0.01
  }
}
#declare FrontWindow = union {
  object { CSG001 }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <22.0, 0.25, 21.0>
  }
  translate  <-30.0, -78.5, 50.0>
}
#declare CSG004 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 18.5, 22.5>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 16.0, 20.0>
  }
  material {
    T_Wood5
    scale 0.01
  }
}
#declare SideWindowFront = union {
  object { CSG004 }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.25, 17.0, 21.0>
  }
  translate  <-78.5, -35.0, 48.0>
}
#declare CSG005 = difference {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 18.5, 22.5>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 16.0, 20.0>
  }
  material {
    T_Wood5
    scale 0.01
  }
}
#declare SideWindowBack = union {
  object { CSG005 }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass
    }
    scale <0.25, 17.0, 21.0>
  }
  translate  <-78.5, 35.0, 48.0>
}
#declare DoorPanel = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 1.0>
    rotate 90.0*x
    translate  56.0*z
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 0.5, 28.0>
    translate  <0.0, -0.5, 28.0>
  }
  material {
    T_Wood5
    scale 0.5
  }
}
#declare CSG006 = difference {
  torus { // Torus001
    1.5, 0.375  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <0.6, 1.0, 2.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <0.6, 2.0, 1.0>
  }
  translate  <0.0, -0.5, 1.5>
}
#declare CSG007 = difference {
  torus { // Torus002
    1.5, 0.375  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <0.6, 1.0, 2.0>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <0.6, 2.0, 1.0>
  }
  translate  <0.0, -0.5, -1.5>
}
#declare Group006 = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.125, 5.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.375, 0.375, 0.5>
    rotate 90.0*x
    translate  3.0*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.375, 0.375, 0.5>
    rotate 90.0*x
    translate  -3.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.375, 0.375, 3.0>
    translate  <0.0, -2.0, -1.5>
  }
  object { CSG006 }
  object { CSG007 }
  translate  <-13.0, -1.0, 33.0>
}
#declare Group005 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 0.125, 1.0>
    translate  <4.0, -1.0, 52.5>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 0.125, 1.0>
    translate  <4.0, -1.0, 7.5>
  }
  object { Group006 }
  material {
    Rusty_Iron
  }
}
#declare Door = union {
  object { DoorPanel }
  object { Group005 }
  translate  <35.0, -78.5, 0.0>
}
#declare Group007 = union {
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Tolky.ttf",
    "We've Moved!",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <2.75, 2.75, 0.01>
    rotate 90.0*x
    translate  <-8.25, 0.0, 8.0>
  }

  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Tolky.ttf",
    "Come visit us at",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <2.5, 2.5, 0.01>
    rotate 90.0*x
    translate  <-8.25, 0.0, 5.0>
  }

  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Tolky.ttf",
    "our new location",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <2.5, 2.5, 0.01>
    rotate 90.0*x
    translate  <-8.25, 0.0, 2.5>
  }

  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Tolky.ttf",
    "in the valley of fire",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <2.5, 2.5, 0.01>
    rotate 90.0*x
    translate  -9.5*x
  }

  material {
    Material2
  }
}
#declare Sign = union {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      Material1
    }
    scale <12.0, 0.01, 7.0>
    translate  <0.0, 0.01, 5.0>
  }
  object { Group007 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Rusty_Iron
    }
    scale <0.1, 0.1, 1.0>
    rotate <75.0, 2.75, 0.0>
    translate  <0.0, 0.2, 18.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Material3
    }
    scale <0.02, 0.02, 13.5>
    rotate <-0.0, -118.0, -0.0>
    translate  18.15*z
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Material3
    }
    scale <0.02, 0.02, 13.25>
    rotate <-0.0, -242.0, -0.0>
    translate  18.15*z
  }
  rotate -2.75*y
  translate  <37.5, -79.6, 30.0>
}
union { // House
  object { StoneWork }
  object { Roof }
  object { FrontWindow }
  object { SideWindowFront }
  object { SideWindowBack }
  object { Door }
  object { Sign }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Material2
    }
    scale <70.0, 70.0, 0.5>
    translate  1.0*z
  }
  rotate -180.0*z
}


